/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.cert;

import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.cert.CertProduct;
import ru.uss.esf.model.cert.CertProductSet;
import ru.uss.esf.model.cert.CertificateForm;
import ru.uss.esf.model.cert.SaveCertificateRequest;
import ru.uss.esf.validation.cert.CertProductsCheck;

public class CertProductsValidator
extends AbstractClassLevelValidator<CertProductsCheck, SaveCertificateRequest> {
    public static final String FOR_MASS_PRODUCTION = "\u043d\u0430 \u0441\u0435\u0440\u0438\u0439\u043d\u043e\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0441\u0442\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u0430";

    @Override
    public void initialize(CertProductsCheck certProductsCheck) {
        this.annotation = certProductsCheck;
    }

    @Override
    public boolean isValid(SaveCertificateRequest cert, ConstraintValidatorContext constraintValidatorContext) {
        CertProductSet productSet;
        CertProduct certProduct;
        int i;
        List certProducts;
        boolean result = true;
        if (cert == null) {
            return result;
        }
        if (CertificateForm.CTKZ.equals((Object)cert.getForm()) && !FOR_MASS_PRODUCTION.equals(cert.getCertificateCategory()) && (certProducts = LambdaUtils.nullSafeApplyFunction(cert, c -> c.getProductSet().getProducts())) != null) {
            for (i = 0; i < certProducts.size(); ++i) {
                certProduct = (CertProduct)certProducts.get(i);
                if (certProduct.getQuantity() == null) {
                    this.addConstraintViolation(constraintValidatorContext, String.format("productSet.products[%d].quantity", i), "{ess.certificate.productSet.products.quantity.notNull}");
                    result = false;
                }
                if (!StringUtils.isEmpty(certProduct.getUnitNomenclature())) continue;
                this.addConstraintViolation(constraintValidatorContext, String.format("productSet.products[%d].unitNomenclature", i), "{ess.certificate.productSet.products.unitNomenclature.notNull}");
                result = false;
            }
        }
        if (CertificateForm.CT01.equals((Object)cert.getForm()) && !cert.getHasEA() && (productSet = cert.getProductSet()) != null && CollectionUtils.isNotEmpty(productSet.getProducts())) {
            for (i = 0; i < productSet.getProducts().size(); ++i) {
                certProduct = productSet.getProducts().get(i);
                if (certProduct.getQuantity() == null) {
                    this.addConstraintViolation(constraintValidatorContext, String.format("productSet.products[%d].quantity", i), "{ess.certificate.productSet.products.quantity.notNull}");
                    result = false;
                }
                if (!StringUtils.isEmpty(certProduct.getUnitNomenclature())) continue;
                this.addConstraintViolation(constraintValidatorContext, String.format("productSet.products[%d].unitNomenclature", i), "{ess.certificate.productSet.products.unitNomenclature.notNull}");
                result = false;
            }
        }
        return result;
    }
}

