/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.clazz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.esf.validation.common.clazz.MultiplicationOf;

public class MultiplicationOfValidator
extends AbstractClassLevelValidator<MultiplicationOf, Object> {
    private String resultField;
    private String[] multiplyFields;
    private String message;
    private Integer scale;
    private boolean checkOnNullMultiplyFields;

    @Override
    public void initialize(MultiplicationOf constraintAnnotation) {
        this.resultField = constraintAnnotation.resultField();
        this.multiplyFields = constraintAnnotation.multiplyFields();
        this.message = constraintAnnotation.message();
        this.checkOnNullMultiplyFields = constraintAnnotation.checkOnNullMultiplyFields();
        try {
            this.scale = Integer.valueOf(constraintAnnotation.scale());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        boolean allMultiplyFieldsIsNull;
        if (!this.checkOnNullMultiplyFields && (allMultiplyFieldsIsNull = Arrays.stream(this.multiplyFields).allMatch(fieldName -> FieldUtils.getFieldValue(value, fieldName) == null))) {
            return true;
        }
        BigDecimal multiplyResult = new BigDecimal(1);
        for (String field : this.multiplyFields) {
            multiplyResult = multiplyResult.multiply(this.getFieldValue(value, field));
        }
        if (this.scale != null) {
            multiplyResult = multiplyResult.setScale((int)this.scale, RoundingMode.HALF_UP);
        }
        if (multiplyResult.compareTo(this.getFieldValue(value, this.resultField)) != 0) {
            return this.setupContextWithValidationError(context, this.message);
        }
        return true;
    }

    private BigDecimal getFieldValue(Object object, String fieldName) {
        Object value = FieldUtils.getFieldValue(object, fieldName);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf((Long)value);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        return (BigDecimal)value;
    }
}

