/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.field;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.validation.common.field.Text;

public class TextValidator
implements ConstraintValidator<Text, String> {
    private int min;
    private int max;

    @Override
    public void initialize(Text constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        if (this.min <= 0) {
            throw new IllegalStateException("Min text size can not be 0 or lower");
        }
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return !value.trim().isEmpty() && value.length() >= this.min && value.length() <= this.max;
    }
}

