/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import java.util.Collection;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.core.validation.common.PathInfo;
import ru.uss.esf.validation.common.relation.EmptyIfTargetFieldNotContains;

public class EmptyIfTargetFieldNotContainsValidator
implements ConstraintValidator<EmptyIfTargetFieldNotContains, Object> {
    private String checkedField;
    private String targetField;
    private String expectedValue;
    private String message;

    @Override
    public void initialize(EmptyIfTargetFieldNotContains constraintAnnotation) {
        this.checkedField = constraintAnnotation.checkedField();
        this.targetField = constraintAnnotation.targetField();
        this.expectedValue = constraintAnnotation.expectedValue();
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(Object object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        Object targetFieldValue = FieldUtils.getFieldValue(object, this.targetField);
        if (targetFieldValue != null) {
            Collection targetCollection;
            if (targetFieldValue instanceof Collection ? !this.isContainsElement(targetCollection = (Collection)targetFieldValue, this.expectedValue) : !targetFieldValue.toString().isEmpty() && !this.expectedValue.equals(targetFieldValue.toString())) {
                return this.checkEmpty(object, context);
            }
        } else {
            return this.checkEmpty(object, context);
        }
        return true;
    }

    private boolean isContainsElement(Collection<?> targetCollection, String expectedValue) {
        for (Object collectionElement : targetCollection) {
            if (!Objects.equals(expectedValue, Objects.toString(collectionElement, null))) continue;
            return true;
        }
        return false;
    }

    private boolean checkEmpty(Object object, ConstraintValidatorContext context) {
        PathInfo pathInfo = new PathInfo();
        if (FieldUtils.fieldNotEmpty(object, this.checkedField, pathInfo)) {
            for (String path : pathInfo.getPaths()) {
                context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(path).addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

