/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.esf.validation.common.relation.NotEmptyIfIikIsKsn;

public class NotEmptyIfIikIsKsnValidator
implements ConstraintValidator<NotEmptyIfIikIsKsn, Object> {
    private String field;
    private String iikField;
    private String message;

    @Override
    public void initialize(NotEmptyIfIikIsKsn constraintAnnotation) {
        this.field = constraintAnnotation.field();
        this.iikField = constraintAnnotation.iikField();
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        Object fieldValue;
        context.disableDefaultConstraintViolation();
        String iik = (String)FieldUtils.getFieldValue(value, this.iikField);
        if (iik == null || iik.length() < 8) {
            return true;
        }
        if (iik.charAt(7) == '3' && ((fieldValue = FieldUtils.getFieldValue(value, this.field)) == null || fieldValue.toString().isEmpty())) {
            context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(this.field).addConstraintViolation();
            return false;
        }
        return true;
    }
}

