/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.core.validation.common.PathInfo;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldIsEmpty;

public class NotEmptyIfTargetFieldIsEmptyValidator
implements ConstraintValidator<NotEmptyIfTargetFieldIsEmpty, Object> {
    private String fieldName;
    private String targetFieldName;
    private String message;

    @Override
    public void initialize(NotEmptyIfTargetFieldIsEmpty constraintAnnotation) {
        this.fieldName = constraintAnnotation.checkedField();
        this.targetFieldName = constraintAnnotation.targetField();
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(Object object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (FieldUtils.fieldNotEmpty(object, this.targetFieldName)) {
            return true;
        }
        PathInfo pathInfo = new PathInfo();
        if (FieldUtils.fieldNotEmpty(object, this.fieldName, pathInfo)) {
            return true;
        }
        for (String path : pathInfo.getPaths()) {
            context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(path).addConstraintViolation();
        }
        return false;
    }
}

