/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.relation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.core.validation.common.PathInfo;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldLengthEquals;

public class NotEmptyIfTargetFieldLengthEqualsValidator
implements ConstraintValidator<NotEmptyIfTargetFieldLengthEquals, Object> {
    private String fieldName;
    private String targetFieldName;
    private int targetFieldLength;
    private String message;

    @Override
    public void initialize(NotEmptyIfTargetFieldLengthEquals constraintAnnotation) {
        this.fieldName = constraintAnnotation.field();
        this.targetFieldName = constraintAnnotation.targetField();
        this.targetFieldLength = constraintAnnotation.targetFieldLength();
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(Object object, ConstraintValidatorContext context) {
        PathInfo pathInfo;
        context.disableDefaultConstraintViolation();
        if (FieldUtils.fieldNotEmpty(object, this.targetFieldName) && ((String)FieldUtils.getFieldValue(object, this.targetFieldName)).length() == this.targetFieldLength && !FieldUtils.fieldNotEmpty(object, this.fieldName, pathInfo = new PathInfo())) {
            for (String path : pathInfo.getPaths()) {
                context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(path).addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

