/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.econtract.version.v1;

import java.util.LinkedList;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.econtract.version.v1.EcontractPaymentScheduleV1;
import ru.uss.esf.model.econtract.version.v1.EcontractPaymentV1;
import ru.uss.esf.validation.econtract.version.v1.AscendingPaymentDatesV1;

public class AscendingPaymentDatesValidatorV1
extends AbstractClassLevelValidator<AscendingPaymentDatesV1, EcontractPaymentScheduleV1> {
    @Override
    public void initialize(AscendingPaymentDatesV1 ascendingPaymentDatesV1) {
        this.annotation = ascendingPaymentDatesV1;
    }

    @Override
    public boolean isValid(EcontractPaymentScheduleV1 paymentScheduleV1, ConstraintValidatorContext context) {
        if (paymentScheduleV1 == null || CollectionUtils.isEmpty(paymentScheduleV1.getPayments())) {
            return true;
        }
        if (paymentScheduleV1.getPayments().size() < 2) {
            return true;
        }
        LinkedList<String> properties = new LinkedList<String>();
        for (int index = 1; index < paymentScheduleV1.getPayments().size(); ++index) {
            EcontractPaymentV1 currentPayment;
            EcontractPaymentV1 previousPayment = paymentScheduleV1.getPayments().get(index - 1);
            if (this.isValidPaymentDate(previousPayment, currentPayment = paymentScheduleV1.getPayments().get(index))) continue;
            properties.add(String.format("payments[%d].paymentDate", index));
        }
        if (!CollectionUtils.isEmpty(properties)) {
            properties.forEach(p -> this.addConstraintViolation(context, (String)p, ((AscendingPaymentDatesV1)this.annotation).message()));
            return false;
        }
        return true;
    }

    protected boolean isValidPaymentDate(EcontractPaymentV1 previousPayment, EcontractPaymentV1 currentPayment) {
        return previousPayment != null && currentPayment != null && currentPayment.getPaymentDate().after(previousPayment.getPaymentDate());
    }
}

