/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.econtract.version.v1;

import java.math.BigDecimal;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.econtract.version.v1.EcontractProductV1;
import ru.uss.esf.validation.econtract.version.v1.CorrectSumInNationalCurrencyV1;

public class CorrectSumInNationalCurrencyValidatorV1
extends AbstractClassLevelValidator<CorrectSumInNationalCurrencyV1, EcontractProductV1> {
    @Override
    public void initialize(CorrectSumInNationalCurrencyV1 correctSumInNationalCurrencyV1) {
        this.annotation = correctSumInNationalCurrencyV1;
    }

    @Override
    public boolean isValid(EcontractProductV1 productV1, ConstraintValidatorContext constraintValidatorContext) {
        if (productV1 == null) {
            return true;
        }
        if (StringUtils.isBlank(productV1.getCurrencyCode())) {
            return true;
        }
        if ("KZT".equals(productV1.getCurrencyCode()) && this.isValidSumInNationalCurrency(productV1.getSum(), BigDecimal.ONE, productV1.getSumInNationalCurrency())) {
            return this.setupContextWithValidationError(constraintValidatorContext, "{econtract.stages.products.sumInNationalCurrency.incorrectForNationalCurrency}");
        }
        if (this.isValidSumInNationalCurrency(productV1.getSum(), productV1.getCurrencyRate(), productV1.getSumInNationalCurrency())) {
            return this.setupContextWithValidationError(constraintValidatorContext, "{econtract.stages.products.sumInNationalCurrency.incorrectForForeignCurrency}");
        }
        return true;
    }

    private boolean isValidSumInNationalCurrency(BigDecimal givenSum, BigDecimal rate, BigDecimal givenSumInNationalCurrency) {
        if (givenSum == null || rate == null || givenSumInNationalCurrency == null) {
            return false;
        }
        return givenSumInNationalCurrency.compareTo(givenSum.multiply(rate)) != 0;
    }
}

