/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.econtract.version.v1;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.econtract.abstractecontract.AbstractEcontractParticipant;
import ru.uss.esf.model.econtract.version.v1.EcontractV1;
import ru.uss.esf.validation.econtract.version.v1.NonDuplicateParticipantV1;

public class NonDuplicateParticipantValidatorV1
extends AbstractClassLevelValidator<NonDuplicateParticipantV1, EcontractV1> {
    @Override
    public void initialize(NonDuplicateParticipantV1 nonDuplicateParticipantV1) {
        this.annotation = nonDuplicateParticipantV1;
    }

    @Override
    public boolean isValid(EcontractV1 econtractV1, ConstraintValidatorContext context) {
        if (econtractV1 == null) {
            return true;
        }
        LinkedList<String> properties = new LinkedList<String>();
        properties.addAll(this.findIntersections(econtractV1.getSuppliers(), "suppliers[%d].tin", econtractV1.getCustomers(), "customers[%d].tin"));
        properties.addAll(this.findIntersections(econtractV1.getSupplierSuccessors(), "supplierSuccessors[%d].tin", econtractV1.getCustomers(), "customers[%d].tin"));
        properties.addAll(this.findIntersections(econtractV1.getSuppliers(), "suppliers[%d].tin", econtractV1.getCustomerSuccessors(), "customerSuccessors[%d].tin"));
        properties.addAll(this.findIntersections(econtractV1.getSupplierSuccessors(), "supplierSuccessors[%d].tin", econtractV1.getCustomerSuccessors(), "customerSuccessors[%d].tin"));
        properties.addAll(this.findDuplicates(econtractV1.getSuppliers(), "suppliers[%d].tin"));
        properties.addAll(this.findDuplicates(econtractV1.getCustomers(), "customers[%d].tin"));
        if (!CollectionUtils.isEmpty(properties)) {
            properties.forEach(p -> this.addConstraintViolation(context, (String)p, ((NonDuplicateParticipantV1)this.annotation).message()));
            return false;
        }
        return true;
    }

    private List<String> findIntersections(List<? extends AbstractEcontractParticipant> onePartyParticipants, String onePartyParticipantProperty, List<? extends AbstractEcontractParticipant> otherPartyParticipants, String otherPartyParticipantProperty) {
        if (CollectionUtils.isEmpty(onePartyParticipants) || CollectionUtils.isEmpty(otherPartyParticipants)) {
            return Collections.emptyList();
        }
        LinkedList<String> properties = new LinkedList<String>();
        for (int oneIndex = 0; oneIndex < onePartyParticipants.size(); ++oneIndex) {
            AbstractEcontractParticipant oneParticipant = onePartyParticipants.get(oneIndex);
            for (int otherIndex = 0; otherIndex < otherPartyParticipants.size(); ++otherIndex) {
                AbstractEcontractParticipant otherParticipant = otherPartyParticipants.get(otherIndex);
                if (StringUtils.isEmpty(oneParticipant.getTin()) || StringUtils.isEmpty(otherParticipant.getTin()) || !oneParticipant.getTin().equals(otherParticipant.getTin())) continue;
                properties.add(String.format(onePartyParticipantProperty, oneIndex));
                properties.add(String.format(otherPartyParticipantProperty, otherIndex));
            }
        }
        return properties;
    }

    private List<String> findDuplicates(List<? extends AbstractEcontractParticipant> participants, String participantProperty) {
        if (CollectionUtils.isEmpty(participants) || participants.stream().anyMatch(p -> StringUtils.isEmpty(p.getTin()))) {
            return Collections.emptyList();
        }
        LinkedList<String> properties = new LinkedList<String>();
        Map<String, List<AbstractEcontractParticipant>> participantsByTin = participants.stream().collect(Collectors.groupingBy(p -> p.getTin()));
        for (int index = 0; index < participants.size(); ++index) {
            AbstractEcontractParticipant participant = participants.get(index);
            List<AbstractEcontractParticipant> duplicates = participantsByTin.get(participant.getTin());
            if (CollectionUtils.isEmpty(duplicates) || duplicates.size() <= 1) continue;
            properties.add(String.format(participantProperty, index));
        }
        return properties;
    }
}

