/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.econtract.version.v1;

import java.util.LinkedList;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.econtract.version.v1.EcontractProductV1;
import ru.uss.esf.model.econtract.version.v1.EcontractStageV1;
import ru.uss.esf.model.econtract.version.v1.EcontractV1;
import ru.uss.esf.validation.econtract.version.v1.PresenceOfProductCurrencyCodeForMultiCurrencyEcontractV1;

public class PresenceOfProductCurrencyCodeForMultiCurrencyEcontractValidatorV1
extends AbstractClassLevelValidator<PresenceOfProductCurrencyCodeForMultiCurrencyEcontractV1, EcontractV1> {
    @Override
    public void initialize(PresenceOfProductCurrencyCodeForMultiCurrencyEcontractV1 presenceOfProductCurrencyCodeForMultiCurrencyEcontractV1) {
        this.annotation = presenceOfProductCurrencyCodeForMultiCurrencyEcontractV1;
    }

    @Override
    public boolean isValid(EcontractV1 econtractV1, ConstraintValidatorContext context) {
        if (econtractV1 == null) {
            return true;
        }
        if (econtractV1.getCurrency() == null || BooleanUtils.isFalse(econtractV1.getCurrency().getMultiCurrency())) {
            return true;
        }
        LinkedList<String> invalidProperties = new LinkedList<String>();
        if (!CollectionUtils.isEmpty(econtractV1.getStages())) {
            for (int stageIndex = 0; stageIndex < econtractV1.getStages().size(); ++stageIndex) {
                EcontractStageV1 stageV1 = econtractV1.getStages().get(stageIndex);
                if (CollectionUtils.isEmpty(stageV1.getProducts())) continue;
                for (int productIndex = 0; productIndex < stageV1.getProducts().size(); ++productIndex) {
                    EcontractProductV1 productV1 = stageV1.getProducts().get(productIndex);
                    if (!StringUtils.isBlank(productV1.getCurrencyCode())) continue;
                    invalidProperties.add(String.format("stages[%d].products[%d].currencyCode", stageIndex, productIndex));
                }
            }
        }
        if (!CollectionUtils.isEmpty(invalidProperties)) {
            invalidProperties.forEach(property -> this.addConstraintViolation(context, (String)property, ((PresenceOfProductCurrencyCodeForMultiCurrencyEcontractV1)this.annotation).message()));
            return false;
        }
        return true;
    }
}

