/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.econtract.version.v1;

import java.util.EnumSet;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.econtract.abstractecontract.EcontractType;
import ru.uss.esf.model.econtract.version.v1.EcontractCustomerV1;
import ru.uss.esf.model.econtract.version.v1.EcontractSupplierV1;
import ru.uss.esf.model.econtract.version.v1.EcontractV1;
import ru.uss.esf.validation.econtract.version.v1.PresenceOfSuccessorsV1;

public class PresenceOfSuccessorsValidatorV1
extends AbstractClassLevelValidator<PresenceOfSuccessorsV1, EcontractV1> {
    private EnumSet applicableTypes = EnumSet.of(EcontractType.CESSION_OF_RIGHTS);

    @Override
    public void initialize(PresenceOfSuccessorsV1 presenceOfSuccessorsV1) {
        this.annotation = presenceOfSuccessorsV1;
    }

    @Override
    public boolean isValid(EcontractV1 eContractV1, ConstraintValidatorContext context) {
        if (eContractV1 == null) {
            return true;
        }
        if (!this.applicableTypes.contains((Object)eContractV1.getType())) {
            if (!CollectionUtils.isEmpty(eContractV1.getSupplierSuccessors()) || !CollectionUtils.isEmpty(eContractV1.getCustomerSuccessors())) {
                return this.setupContextWithValidationError(context, "supplierSuccessors", "{econtract.successors.mustBeEmpty}");
            }
            return true;
        }
        if (CollectionUtils.isEmpty(eContractV1.getSupplierSuccessors()) && CollectionUtils.isEmpty(eContractV1.getCustomerSuccessors())) {
            return this.setupContextWithValidationError(context, "{econtract.successors.size}");
        }
        if (!CollectionUtils.isEmpty(eContractV1.getSupplierSuccessors()) && !CollectionUtils.isEmpty(eContractV1.getSuppliers())) {
            for (EcontractSupplierV1 supplierSuccessor : eContractV1.getSupplierSuccessors()) {
                if (eContractV1.getSuppliers().stream().anyMatch(s -> s.getNumber().equals(supplierSuccessor.getNumber()))) continue;
                return this.setupContextWithValidationError(context, String.format("supplierSuccessors[%d].number", eContractV1.getSupplierSuccessors().indexOf(supplierSuccessor)), "{econtract.supplierSuccessor.number.outOfRange}");
            }
        }
        if (!CollectionUtils.isEmpty(eContractV1.getCustomerSuccessors()) && !CollectionUtils.isEmpty(eContractV1.getCustomers())) {
            for (EcontractCustomerV1 customerSuccessor : eContractV1.getCustomerSuccessors()) {
                if (eContractV1.getCustomers().stream().anyMatch(s -> s.getNumber().equals(customerSuccessor.getNumber()))) continue;
                return this.setupContextWithValidationError(context, String.format("supplierSuccessors[%d].number", eContractV1.getCustomerSuccessors().indexOf(customerSuccessor)), "{econtract.customerSuccessor.number.outOfRange}");
            }
        }
        return true;
    }
}

