/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.econtract.version.v1;

import java.util.LinkedList;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.econtract.version.v1.EcontractStageV1;
import ru.uss.esf.model.econtract.version.v1.EcontractV1;
import ru.uss.esf.validation.econtract.version.v1.StageImplementationDeadlineOrderV1;

public class StageImplementationDeadlineOrderValidatorV1
extends AbstractClassLevelValidator<StageImplementationDeadlineOrderV1, EcontractV1> {
    @Override
    public void initialize(StageImplementationDeadlineOrderV1 constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(EcontractV1 econtractV1, ConstraintValidatorContext constraintValidatorContext) {
        if (econtractV1 == null) {
            return true;
        }
        if (CollectionUtils.isEmpty(econtractV1.getStages())) {
            return true;
        }
        if (econtractV1.getStages().size() < 2) {
            return true;
        }
        String property = "stages[%d].totalImplementationDeadline";
        LinkedList<String> properties = new LinkedList<String>();
        for (int index = 1; index < econtractV1.getStages().size(); ++index) {
            EcontractStageV1 currentStage;
            EcontractStageV1 previousStage = econtractV1.getStages().get(index - 1);
            if (this.isValidImplementationDate(previousStage, currentStage = econtractV1.getStages().get(index))) continue;
            properties.add(String.format(property, index));
        }
        if (!CollectionUtils.isEmpty(properties)) {
            properties.forEach(p -> this.addConstraintViolation(constraintValidatorContext, (String)p, ((StageImplementationDeadlineOrderV1)this.annotation).message()));
            return false;
        }
        return true;
    }

    protected boolean isValidImplementationDate(EcontractStageV1 previous, EcontractStageV1 current) {
        if (previous != null && current != null && previous.getTotalImplementationDeadline() != null && current.getTotalImplementationDeadline() != null) {
            return previous.getTotalImplementationDeadline().before(current.getTotalImplementationDeadline());
        }
        return true;
    }
}

