/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.clazz;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.invoice.abstractinvoice.RelatedInvoice;
import ru.uss.esf.validation.invoice.clazz.RegistrationNumber;

public class RegistrationNumberValidator
implements ConstraintValidator<RegistrationNumber, RelatedInvoice> {
    @Override
    public void initialize(RegistrationNumber constraintAnnotation) {
    }

    @Override
    public boolean isValid(RelatedInvoice value, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (value.getDate() != null) {
            if (value.getDate().after(DateTimeUtils.ESF_START_DATE)) {
                if (value.getRegistrationNumber() == null) {
                    context.buildConstraintViolationWithTemplate("{relatedInvoice.registrationNumber.notNull}").addConstraintViolation();
                    return false;
                }
            } else if (value.getRegistrationNumber() != null) {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.registrationNumber.redundant}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

