/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.CustomerTypeV1;
import ru.uss.esf.model.invoice.version.v1.CustomerV1;
import ru.uss.esf.validation.invoice.version.v1.CustomersParticipantsV1;

public class CustomersParticipantsValidatorV1
implements ConstraintValidator<CustomersParticipantsV1, List<CustomerV1>> {
    @Override
    public void initialize(CustomersParticipantsV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(List<CustomerV1> customers, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (customers == null || customers.isEmpty()) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.customers.notEmpty}").addConstraintViolation();
            return false;
        }
        ArrayList<String> tins = new ArrayList<String>();
        for (CustomerV1 customer : customers) {
            if (customer == null) {
                context.buildConstraintViolationWithTemplate("{invoiceV1.customers.elementIsNull}").addConstraintViolation();
                return false;
            }
            if (customers.size() == 1) {
                if (customer.getStatuses() != null && customer.getStatuses().contains(CustomerTypeV1.JOINT_ACTIVITY_PARTICIPANT)) {
                    context.buildConstraintViolationWithTemplate("{invoiceV1.customers.singleIsNotParticipant}").addConstraintViolation();
                    return false;
                }
            } else if (customer.getStatuses() == null || !customer.getStatuses().contains(CustomerTypeV1.JOINT_ACTIVITY_PARTICIPANT)) {
                context.buildConstraintViolationWithTemplate("{invoiceV1.customers.oneIsNotParticipant}").addConstraintViolation();
                return false;
            }
            tins.add(customer.getTin());
        }
        if (tins.size() != new HashSet(tins).size()) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.customers.duplicatedTin}").addConstraintViolation();
            return false;
        }
        return true;
    }
}

