/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.model.invoice.version.v1.ProductV1;
import ru.uss.esf.model.invoice.version.v1.SellerV1;
import ru.uss.esf.validation.invoice.version.v1.NdsRateV1;

public class NdsRateValidatorV1
implements ConstraintValidator<NdsRateV1, InvoiceV1> {
    @Override
    public void initialize(NdsRateV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV1 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getSellers() == null || invoice.getProductSet() == null || invoice.getProductSet().getProducts() == null) {
            return true;
        }
        for (SellerV1 seller : invoice.getSellers()) {
            if (seller.getCertificateNum() == null || seller.getCertificateNum().isEmpty() || seller.getCertificateSeries() == null || seller.getCertificateSeries().isEmpty()) continue;
            return true;
        }
        boolean valid = true;
        for (int i = 0; i < invoice.getProductSet().getProducts().size(); ++i) {
            ProductV1 p = invoice.getProductSet().getProducts().get(i);
            if (p.getNdsRate() == null) continue;
            context.buildConstraintViolationWithTemplate("{invoiceV1.products.ndsRate.exists}").addPropertyNode("productSet.products[" + i + "].ndsRate").addConstraintViolation();
            valid = false;
        }
        return valid;
    }
}

