/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import java.math.BigDecimal;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.model.invoice.version.v1.ParticipantV1;
import ru.uss.esf.model.invoice.version.v1.ProductShareV1;
import ru.uss.esf.model.invoice.version.v1.ProductV1;
import ru.uss.esf.validation.invoice.version.v1.ProductDistributionV1;

public class ProductDistributionValidatorV1
implements ConstraintValidator<ProductDistributionV1, InvoiceV1> {
    @Override
    public void initialize(ProductDistributionV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV1 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getProductSet() == null || invoice.getProductSet().getProducts() == null) {
            return true;
        }
        if (invoice.getInvoiceType() == InvoiceType.ORDINARY_INVOICE || invoice.getInvoiceType() == InvoiceType.FIXED_INVOICE) {
            for (int i = 0; i < invoice.getProductSet().getProducts().size(); ++i) {
                ProductV1 product = invoice.getProductSet().getProducts().get(i);
                if (product.getQuantity() != null && BigDecimal.ZERO.compareTo(product.getQuantity()) >= 0) {
                    context.buildConstraintViolationWithTemplate("{invoiceV1.product.quantity.zeroOrNegative}").addPropertyNode("productSet.products[" + i + "].quantity").addConstraintViolation();
                    return false;
                }
                if (product.getPriceWithTax() == null) {
                    return true;
                }
                if (product.getPriceWithTax().compareTo(BigDecimal.ZERO) >= 0) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV1.product.priceWithTax.negative}").addPropertyNode("productSet.products[" + i + "].priceWithTax").addConstraintViolation();
                return false;
            }
        }
        if (!this.checkQuantity(invoice, context, invoice.getSellerParticipants(), true)) {
            return false;
        }
        return this.checkQuantity(invoice, context, invoice.getCustomerParticipants(), false);
    }

    private boolean checkQuantity(InvoiceV1 invoice, ConstraintValidatorContext context, List<ParticipantV1> participants, boolean sellers) {
        if (participants != null && !participants.isEmpty()) {
            List<ProductV1> productList = invoice.getProductSet().getProducts();
            for (int i = 0; i < productList.size(); ++i) {
                String message;
                ProductV1 p = productList.get(i);
                int productNum = i + 1;
                BigDecimal priceWithoutTax = BigDecimal.ZERO;
                BigDecimal turnoverSize = BigDecimal.ZERO;
                BigDecimal priceWithTax = BigDecimal.ZERO;
                for (ParticipantV1 participant : participants) {
                    if (participant.getProductShares() == null) {
                        return true;
                    }
                    for (ProductShareV1 ps : participant.getProductShares()) {
                        if (ps.getProductNumber() != productNum) continue;
                        if (ps.getPriceWithoutTax() == null) {
                            return true;
                        }
                        if (ps.getTurnoverSize() == null) {
                            return true;
                        }
                        if (ps.getPriceWithTax() == null) {
                            return true;
                        }
                        priceWithoutTax = priceWithoutTax.add(ps.getPriceWithoutTax());
                        turnoverSize = turnoverSize.add(ps.getTurnoverSize());
                        priceWithTax = priceWithTax.add(ps.getPriceWithTax());
                    }
                }
                if (priceWithoutTax.compareTo(p.getPriceWithoutTax()) != 0) {
                    message = sellers ? "{invoiceV1.products.sellers.priceWithoutTax}" : "{invoiceV1.products.customers.priceWithoutTax}";
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].priceWithoutTax").addConstraintViolation();
                    return false;
                }
                if (turnoverSize.compareTo(p.getTurnoverSize()) != 0) {
                    message = sellers ? "{invoiceV1.products.sellers.turnoverSize}" : "{invoiceV1.products.customers.turnoverSize}";
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].turnoverSize").addConstraintViolation();
                    return false;
                }
                if (priceWithTax.compareTo(p.getPriceWithTax()) == 0) continue;
                message = sellers ? "{invoiceV1.products.sellers.priceWithTax}" : "{invoiceV1.products.customers.priceWithTax}";
                context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].priceWithTax").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

