/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import java.util.Calendar;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.validation.invoice.version.v1.RelatedDateV1;

public class RelatedDateValidatorV1
implements ConstraintValidator<RelatedDateV1, InvoiceV1> {
    @Override
    public void initialize(RelatedDateV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV1 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getRelatedInvoice() != null && invoice.getRelatedInvoice().getDate() == null) {
            context.buildConstraintViolationWithTemplate("{relatedInvoice.date.notNull}").addPropertyNode("relatedInvoice.date").addConstraintViolation();
            return false;
        }
        if (invoice.getInvoiceType() == InvoiceType.FIXED_INVOICE || invoice.getInvoiceType() == InvoiceType.ADDITIONAL_INVOICE) {
            if (invoice.getRelatedInvoice() == null || invoice.getRelatedInvoice().getDate() == null) {
                return true;
            }
            Date parentDate = DateTimeUtils.startOfTheDay(invoice.getRelatedInvoice().getDate());
            Date childDate = DateTimeUtils.startOfTheDay(invoice.getDate());
            Calendar cal = Calendar.getInstance();
            cal.setTime(childDate);
            cal.add(1, -5);
            Date dateMinus5Years = cal.getTime();
            if (parentDate.compareTo(dateMinus5Years) < 0) {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.date.tooFar}").addConstraintViolation();
                return false;
            }
            if (parentDate.compareTo(childDate) > 0) {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.date.afterChild}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

