/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1.field;

import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.CustomerTypeV1;
import ru.uss.esf.validation.invoice.version.v1.field.CustomerTypesV1;

public class CustomerTypesValidatorV1
implements ConstraintValidator<CustomerTypesV1, List<CustomerTypeV1>> {
    @Override
    public void initialize(CustomerTypesV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(List<CustomerTypeV1> statusList, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (statusList != null) {
            if (statusList.isEmpty()) {
                context.buildConstraintViolationWithTemplate("{customerV1.statuses.emptyList}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(null)) {
                context.buildConstraintViolationWithTemplate("{customerV1.statuses.containsNull}").addConstraintViolation();
                return false;
            }
            if (statusList.size() != new HashSet<CustomerTypeV1>(statusList).size()) {
                context.buildConstraintViolationWithTemplate("{customerV1.statuses.isDuplicated}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(CustomerTypeV1.COMMITTENT) && statusList.contains(CustomerTypeV1.BROKER)) {
                context.buildConstraintViolationWithTemplate("{customerV1.statuses.commitentAndBrokerMutualExclusive}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(CustomerTypeV1.PUBLIC_OFFICE) && statusList.contains(CustomerTypeV1.JOINT_ACTIVITY_PARTICIPANT)) {
                context.buildConstraintViolationWithTemplate("{customerV1.statuses.publicAndParticipantMutualExclusive}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(CustomerTypeV1.NONRESIDENT) && statusList.contains(CustomerTypeV1.JOINT_ACTIVITY_PARTICIPANT)) {
                context.buildConstraintViolationWithTemplate("{customerV1.statuses.nonresidentAndParticipantMutualExclusive}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

