/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.InvoiceVersionHelper;
import ru.uss.esf.model.invoice.version.v2.ConsigneeV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.NdsRateTypeV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.ConsigneeCountryCodeV2;

public class ConsigneeCountryCodeValidatorV2
implements ConstraintValidator<ConsigneeCountryCodeV2, InvoiceV2> {
    @Override
    public void initialize(ConsigneeCountryCodeV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        ConsigneeV2 consignee = invoice.getConsignee();
        if (consignee == null || consignee.getCountryCode() == null) {
            return true;
        }
        if (invoice.getSellers() == null || invoice.getSellers().size() == 0) {
            return true;
        }
        boolean canExport = invoice.contains(SellerTypeV2.FOR_EXPORT);
        if (consignee.getCountryCode() == null) {
            context.buildConstraintViolationWithTemplate("{consigneeV2.countryCode.notNull}").addPropertyNode("consignee.countryCode").addConstraintViolation();
            return false;
        }
        boolean withoutNdsNotKz = false;
        if (invoice.getProductSet() != null) {
            withoutNdsNotKz = NdsRateTypeV2.WITHOUT_NDS_NOT_KZ.equals((Object)invoice.getProductSet().getNdsRateType());
        }
        if (withoutNdsNotKz) {
            return true;
        }
        if (!(canExport || "KZ".equals(consignee.getCountryCode()) || InvoiceVersionHelper.deliveryDocContainsSnt(invoice))) {
            context.buildConstraintViolationWithTemplate("{consigneeV2.countryCode.foreignCountryForLocalSell}").addPropertyNode("consignee.countryCode").addConstraintViolation();
            return false;
        }
        return true;
    }
}

