/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Collections;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.ProductSetV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.CurrencyRateCheckNullV2;

public class CurrencyRateCheckNullValidatorV2
implements ConstraintValidator<CurrencyRateCheckNullV2, InvoiceV2> {
    @Override
    public void initialize(CurrencyRateCheckNullV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        ProductSetV2 productSet = invoice.getProductSet();
        if (productSet == null) {
            return true;
        }
        boolean canExport = invoice.contains(SellerTypeV2.FOR_EXPORT);
        if ((canExport || invoice.containsCustomerStatus(Collections.singletonList(CustomerTypeV2.SHARING_AGREEMENT_PARTICIPANT))) && !"KZT".equals(productSet.getCurrencyCode()) && productSet.getCurrencyRate() == null) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.productSet.currencyRate.isNull}").addPropertyNode("productSet.currencyRate").addConstraintViolation();
            return false;
        }
        return true;
    }
}

