/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.model.invoice.version.v2.CustomerV2;
import ru.uss.esf.validation.invoice.version.v2.CustomersParticipantsV2;

public class CustomersParticipantsValidatorV2
implements ConstraintValidator<CustomersParticipantsV2, List<CustomerV2>> {
    @Override
    public void initialize(CustomersParticipantsV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(List<CustomerV2> customers, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (customers == null || customers.isEmpty()) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.customers.notEmpty}").addConstraintViolation();
            return false;
        }
        ArrayList<String> tins = new ArrayList<String>();
        for (CustomerV2 customer : customers) {
            if (customer == null) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.customers.elementIsNull}").addConstraintViolation();
                return false;
            }
            if (customer.getStatuses() != null && customer.getStatuses().contains(CustomerTypeV2.NONRESIDENT) && StringUtils.isEmpty(customer.getAddress()) && StringUtils.isEmpty(customer.getTin())) {
                context.buildConstraintViolationWithTemplate("{customerV2.address.notNull}").addConstraintViolation();
                return false;
            }
            tins.add(customer.getTin());
        }
        if (customers.size() == 1 && customers.get(0).getStatuses() != null && customers.get(0).getStatuses().contains(CustomerTypeV2.JOINT_ACTIVITY_PARTICIPANT)) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.customers.singleIsNotParticipant}").addConstraintViolation();
            return false;
        }
        if (customers.size() > 1) {
            boolean allHasJointActivityParticipant = customers.stream().allMatch(c -> c.getStatuses() != null && c.getStatuses().contains(CustomerTypeV2.JOINT_ACTIVITY_PARTICIPANT));
            boolean allHasSharingAgreementParticipant = customers.stream().allMatch(c -> c.getStatuses() != null && c.getStatuses().contains(CustomerTypeV2.SHARING_AGREEMENT_PARTICIPANT));
            if (!allHasJointActivityParticipant && !allHasSharingAgreementParticipant) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.customers.oneIsNotParticipant}").addConstraintViolation();
                return false;
            }
        }
        if (tins.size() != new HashSet(tins).size()) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.customers.duplicatedTin}").addConstraintViolation();
            return false;
        }
        return true;
    }
}

