/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.DeliveryDocNumDateV2;

public class DeliveryDocNumDateValidatorV2
implements ConstraintValidator<DeliveryDocNumDateV2, InvoiceV2> {
    private static final Pattern SNT_PATTERN = Pattern.compile("^KZ-SNT-[0-9]{4}-[0-9]{12}-[0-9]{8}-[0-9]+$", 256);
    private static final Pattern EGP_AWP_PATTERN = Pattern.compile("^[0-9]{6}\\/[0-9]{2}\\/[0-9]{1,2}", 256);

    @Override
    public void initialize(DeliveryDocNumDateV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        if (StringUtils.isNotEmpty(invoice.getDeliveryDocNum2()) || invoice.getDeliveryDocDate2() != null) {
            if (StringUtils.isNotEmpty(invoice.getDeliveryDocNum()) || invoice.getDeliveryDocDate() != null) {
                if ("NON SNT".equals(invoice.getDeliveryDocNum()) && "NON SNT".equals(invoice.getDeliveryDocNum2())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.deliveryFields.both.nonSnt}").addPropertyNode("deliveryDocNum2").addConstraintViolation();
                } else {
                    boolean bl = result = result && this.checkDeliveryFields(invoice, "deliveryDocNum2", "deliveryDocDate2", context);
                    if (!DeliveryDocNumDateValidatorV2.validateSntRegistrationNumber(invoice.getDeliveryDocNum()) && !DeliveryDocNumDateValidatorV2.validateSntRegistrationNumber(invoice.getDeliveryDocNum2()) && !this.isNonSnt(invoice) || !DeliveryDocNumDateValidatorV2.validateEgpAwpRegistrationNumber(invoice.getDeliveryDocNum()) && !DeliveryDocNumDateValidatorV2.validateEgpAwpRegistrationNumber(invoice.getDeliveryDocNum2())) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.deliveryFields.allowedOnly.sntAndEgpAwp}").addPropertyNode("deliveryDocNum").addConstraintViolation();
                    }
                }
            } else {
                context.buildConstraintViolationWithTemplate("{invoiceV2.deliveryFields.secondFieldSet.filled}").addPropertyNode("deliveryDocNum").addConstraintViolation();
            }
        }
        result = result && this.checkDeliveryFields(invoice, "deliveryDocNum", "deliveryDocDate", context);
        return result;
    }

    private boolean checkDeliveryFields(InvoiceV2 invoice, String numProperty, String dateProperty, ConstraintValidatorContext context) {
        boolean result = true;
        String getDeliveryDocNumValue = (String)FieldUtils.getFieldValue(invoice, numProperty);
        if ("NON SNT".equals(getDeliveryDocNumValue)) {
            result = result;
        } else if (FieldUtils.fieldNotEmpty(invoice, numProperty) && FieldUtils.fieldNotEmpty(invoice, dateProperty) || !FieldUtils.fieldNotEmpty(invoice, numProperty) && !FieldUtils.fieldNotEmpty(invoice, dateProperty)) {
            result = result;
        } else {
            if (invoice.getDeliveryDocDate() == null) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.deliveryFields.notConsistent}").addPropertyNode(dateProperty).addConstraintViolation();
            } else {
                context.buildConstraintViolationWithTemplate("{invoiceV2.deliveryFields.notConsistent}").addPropertyNode(numProperty).addConstraintViolation();
            }
            if (result) {
                // empty if block
            }
            result = false;
        }
        return result;
    }

    private static boolean validateRegistrationNumber(String number, Pattern pattern) {
        if (number == null) {
            return false;
        }
        return pattern.matcher(number).find();
    }

    private static boolean validateEgpAwpRegistrationNumber(String number) {
        return DeliveryDocNumDateValidatorV2.validateRegistrationNumber(number, EGP_AWP_PATTERN);
    }

    private static boolean validateSntRegistrationNumber(String number) {
        return DeliveryDocNumDateValidatorV2.validateRegistrationNumber(number, SNT_PATTERN);
    }

    private boolean isNonSnt(InvoiceV2 invoice) {
        return "NON SNT".equals(invoice.getDeliveryDocNum()) || "NON SNT".equals(invoice.getDeliveryDocNum2());
    }
}

