/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.InvoiceVersionHelper;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.invoice.version.v2.DeliveryTermV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.DeliveryTermContractV2;

public class DeliveryTermContractValidatorV2
extends AbstractClassLevelValidator<DeliveryTermContractV2, InvoiceV2> {
    public static final Pattern ACCOUNT_NUMBER_PATTERN = Pattern.compile("([12])/[0-9]{3}/[0-9]{4}/[0-9]{1,20}");

    @Override
    public void initialize(DeliveryTermContractV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoiceV2, ConstraintValidatorContext context) {
        boolean hasError = false;
        DeliveryTermV2 deliveryTerm = invoiceV2.getDeliveryTerm();
        if (deliveryTerm != null) {
            if (deliveryTerm.isHasContract()) {
                if (deliveryTerm.getContractDate() == null || StringUtils.isEmpty(deliveryTerm.getContractNum())) {
                    this.setupContextWithValidationError(context, "deliveryTerm.hasContract", "{invoiceV2.deliveryTerm.contract.notConsistent}");
                    hasError = true;
                }
            } else {
                if (deliveryTerm.getContractDate() != null) {
                    this.setupContextWithValidationError(context, "deliveryTerm.contractDate", "{invoiceV2.deliveryTerm.contractDate.notConsistent}");
                    hasError = true;
                }
                if (!StringUtils.isEmpty(deliveryTerm.getContractNum())) {
                    this.setupContextWithValidationError(context, "deliveryTerm.contractNum", "{invoiceV2.deliveryTerm.contractNum.notConsistent}");
                    hasError = true;
                }
            }
            if (StringUtils.isNotEmpty(deliveryTerm.getAccountNumber())) {
                if (!BooleanUtils.isTrue(deliveryTerm.isHasContract())) {
                    this.setupContextWithValidationError(context, "deliveryTerm.accountNumber", "{invoiceV2.deliveryTerm..accountNumber.mustBeNull}");
                    hasError = true;
                }
                if (!invoiceV2.isForExport() || "KZ".equals(InvoiceVersionHelper.getExportCountry(invoiceV2))) {
                    this.setupContextWithValidationError(context, "deliveryTerm.accountNumber", "{invoiceV2.deliveryTerm.accountNumber.mustBeNull}");
                    hasError = true;
                }
                if (!ACCOUNT_NUMBER_PATTERN.matcher(deliveryTerm.getAccountNumber()).matches()) {
                    this.setupContextWithValidationError(context, "deliveryTerm.accountNumber", "{invoiceV2.deliveryTerm.accountNumber.wrongFormat}");
                    hasError = true;
                }
            }
        }
        return !hasError;
    }
}

