/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.CustomerV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.invoice.version.v2.IndividualTinCheckV2;

public class IndividualTinCheckValidatorV2
implements ConstraintValidator<IndividualTinCheckV2, InvoiceV2> {
    @Override
    public void initialize(IndividualTinCheckV2 IndividualTinCheckV22) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        if (invoice.getInvoiceType() == InvoiceType.ORDINARY_INVOICE && CollectionUtils.isNotEmpty(invoice.getCustomers())) {
            for (int i = 0; i < invoice.getCustomers().size(); ++i) {
                CustomerV2 customer = invoice.getCustomers().get(i);
                if (!customer.isIndividual() || !StringUtils.isNotEmpty(customer.getTin()) || !Pattern.matches("[0-9]{12}", customer.getTin()) || TinValidator.isIin(customer.getTin())) continue;
                context.buildConstraintViolationWithTemplate("{customerV2.tin.isNotForIndividual}").addPropertyNode("customers[" + i + "].tin").addConstraintViolation();
                result = false;
            }
        }
        return result;
    }
}

