/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.NdsRateTypeV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.model.invoice.version.v2.SellerV2;
import ru.uss.esf.validation.invoice.version.v2.NdsRateV2;

public class NdsRateValidatorV2
implements ConstraintValidator<NdsRateV2, InvoiceV2> {
    public static final List<String> SPECIAL_TIN_LIST = Collections.singletonList("941140000338");

    @Override
    public void initialize(NdsRateV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        SellerV2 creator;
        List<SellerTypeV2> statuses;
        boolean canEditNdsRateWithoutNdsPayer;
        context.disableDefaultConstraintViolation();
        if (invoice.getSellers() == null || invoice.getProductSet() == null || invoice.getProductSet().getProducts() == null) {
            return true;
        }
        boolean valid = true;
        boolean isTaxpayerNdsPayer = false;
        boolean withoutNdsNotKz = NdsRateTypeV2.WITHOUT_NDS_NOT_KZ.equals((Object)invoice.getProductSet().getNdsRateType());
        for (SellerV2 seller : invoice.getSellers()) {
            if (!StringUtils.isNotEmpty(seller.getCertificateNum()) || !StringUtils.isNotEmpty(seller.getCertificateSeries())) continue;
            isTaxpayerNdsPayer = true;
            break;
        }
        boolean bl = canEditNdsRateWithoutNdsPayer = (statuses = (creator = invoice.getSellers().get(0)).getStatuses()) != null && (statuses.contains(SellerTypeV2.BROKER) || statuses.contains(SellerTypeV2.FORWARDER));
        if (SPECIAL_TIN_LIST.contains(creator.getTin())) {
            canEditNdsRateWithoutNdsPayer = true;
        }
        if (!isTaxpayerNdsPayer && !canEditNdsRateWithoutNdsPayer || withoutNdsNotKz) {
            for (int i = 0; i < invoice.getProductSet().getProducts().size(); ++i) {
                ProductV2 p = invoice.getProductSet().getProducts().get(i);
                if (p.getNdsRate() != null) {
                    if (!isTaxpayerNdsPayer && invoice.getInvoiceType() != InvoiceType.FIXED_INVOICE) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.ndsRate.exists}").addPropertyNode("productSet.products[" + i + "].ndsRate").addConstraintViolation();
                        valid = false;
                    }
                    if (withoutNdsNotKz) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.withoutNdsNotKz.ndsRate.exists}").addPropertyNode("productSet.products[" + i + "].ndsRate").addConstraintViolation();
                        valid = false;
                    }
                }
                if (BigDecimal.ZERO.equals(p.getNdsAmount()) || invoice.getInvoiceType() == InvoiceType.FIXED_INVOICE) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.product.ndsAmount.mustBeZero}").addPropertyNode("productSet.products[" + i + "].ndsRate").addConstraintViolation();
                valid = false;
            }
        }
        return valid;
    }
}

