/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.math.BigDecimal;
import java.util.Collections;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.ProductDigitsFormatV2;

public class ProductDigitsFormatValidatorV2
implements ConstraintValidator<ProductDigitsFormatV2, InvoiceV2> {
    @Override
    public void initialize(ProductDigitsFormatV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getProductSet() == null || invoice.getProductSet().getProducts() == null) {
            return true;
        }
        boolean result = true;
        if (!InvoiceType.ORDINARY_INVOICE.equals(invoice.getInvoiceType())) {
            return true;
        }
        boolean isExporterAndSrp = invoice.contains(Collections.singletonList(SellerTypeV2.EXPORTER)) && invoice.contains(Collections.singletonList(SellerTypeV2.SHARING_AGREEMENT_PARTICIPANT));
        boolean isNonResident = invoice.isCustomerNonResident();
        boolean isKztCurrency = StringUtils.isEmpty(invoice.getProductSet().getCurrencyCode()) || "KZT".equals(invoice.getProductSet().getCurrencyCode());
        boolean allowUnitPriceScale3 = isExporterAndSrp && isNonResident && !isKztCurrency;
        for (int i = 0; i < invoice.getProductSet().getProducts().size(); ++i) {
            int scale;
            ProductV2 product = invoice.getProductSet().getProducts().get(i);
            BigDecimal unitPrice = product.getUnitPrice();
            if (unitPrice == null || (scale = unitPrice.scale()) <= 3 && (scale != 3 || allowUnitPriceScale3)) continue;
            context.buildConstraintViolationWithTemplate("{invoiceV2.product.unitPrice.scale}").addPropertyNode("productSet.products[" + i + "].unitPrice").addConstraintViolation();
            result = false;
        }
        return result;
    }
}

