/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.DistributionUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.ParticipantV2;
import ru.uss.esf.model.invoice.version.v2.ProductSetV2;
import ru.uss.esf.model.invoice.version.v2.ProductShareV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.model.invoice.version.v2.SellerV2;
import ru.uss.esf.validation.invoice.version.v2.ProductDistributionV2;

public class ProductDistributionValidatorV2
implements ConstraintValidator<ProductDistributionV2, InvoiceV2> {
    private static final List<Integer> VALID_NDS_RATES = Arrays.asList(0, 12);
    static final List<String> valuesTruOriginCodeForMandatoryDescription = Arrays.asList("3", "4", "5", "6");
    static final List<String> valuesTruOriginCodeForMandatoryTnvedName = Arrays.asList("1", "2");
    static final List<String> valuesTruOriginCodeForMandatoryUnitCode = Arrays.asList("1", "2", "3");
    static final List<String> valuesTruOriginCodeForMandatoryUnitNomenclature = Arrays.asList("1", "2", "3", "4", "5");
    static final List<String> valuesTruOriginCodeForMandatoryQuantity = Arrays.asList("1", "2", "3", "4", "5");
    static final List<String> valuesTruOriginCodeForMandatoryProductDeclaration = Arrays.asList("1", "3");
    static final List<String> eaeuCountryCodes = Arrays.asList("AM", "BY", "KZ", "KG", "RU");
    static final List<String> valuesTruOriginCodeForMandatoryProductNumberInDeclaration = Arrays.asList("1");
    public static final Date DATE_010719 = DateTimeUtils.getDate("01.07.2019");

    @Override
    public void initialize(ProductDistributionV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getProductSet() == null || invoice.getProductSet().getProducts() == null) {
            return true;
        }
        boolean countryIsEaecMember = invoice.getCustomers().stream().anyMatch(customer -> eaeuCountryCodes.contains(customer.getCountryCode()) && !"KZ".equals(customer.getCountryCode()));
        boolean countryIsKZ = invoice.getCustomers().stream().anyMatch(customer -> "KZ".equals(customer.getCountryCode()));
        boolean hasError = false;
        InvoiceType invoiceType = invoice.getInvoiceType();
        if (invoiceType == InvoiceType.ORDINARY_INVOICE || invoiceType == InvoiceType.FIXED_INVOICE || invoiceType == InvoiceType.ADDITIONAL_INVOICE) {
            for (int i = 0; i < invoice.getProductSet().getProducts().size(); ++i) {
                ProductV2 product = invoice.getProductSet().getProducts().get(i);
                if (product.getQuantity() != null && BigDecimal.ZERO.compareTo(product.getQuantity()) >= 0 && invoiceType != InvoiceType.ADDITIONAL_INVOICE) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.quantity.zeroOrNegative}").addPropertyNode("productSet.products[" + i + "].quantity").addConstraintViolation();
                    hasError = true;
                }
                if (!"6".equals(product.getTruOriginCode()) && product.getUnitPrice() == null && invoiceType != InvoiceType.ADDITIONAL_INVOICE) {
                    context.buildConstraintViolationWithTemplate("{productV2.unitPrice.notNull}").addPropertyNode("productSet.products[" + i + "].unitPrice").addConstraintViolation();
                    hasError = true;
                } else if (product.getUnitPrice() != null && BigDecimal.ZERO.compareTo(product.getUnitPrice()) > 0 && invoiceType != InvoiceType.ADDITIONAL_INVOICE) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.unitPrice.negative}").addPropertyNode("productSet.products[" + i + "].unitPrice").addConstraintViolation();
                    hasError = true;
                }
                if (product.getPriceWithoutTax() != null && BigDecimal.ZERO.compareTo(product.getPriceWithoutTax()) > 0 && invoiceType != InvoiceType.ADDITIONAL_INVOICE) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.priceWithoutTax.negative}").addPropertyNode("productSet.products[" + i + "].priceWithoutTax").addConstraintViolation();
                    hasError = true;
                }
                if (product.getTurnoverSize() != null && BigDecimal.ZERO.compareTo(product.getTurnoverSize()) > 0 && invoiceType != InvoiceType.ADDITIONAL_INVOICE) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.turnoverSize.negative}").addPropertyNode("productSet.products[" + i + "].turnoverSize").addConstraintViolation();
                    hasError = true;
                }
                if (product.getPriceWithTax() != null && product.getPriceWithTax().compareTo(BigDecimal.ZERO) < 0 && invoiceType != InvoiceType.ADDITIONAL_INVOICE) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.priceWithTax.negative}").addPropertyNode("productSet.products[" + i + "].priceWithTax").addConstraintViolation();
                    hasError = true;
                }
                if (StringUtils.isEmpty(product.getDescription()) && valuesTruOriginCodeForMandatoryDescription.contains(product.getTruOriginCode())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.description.notNull}").addPropertyNode("productSet.products[" + i + "].description").addConstraintViolation();
                    hasError = true;
                }
                if (StringUtils.isEmpty(product.getTnvedName()) && valuesTruOriginCodeForMandatoryTnvedName.contains(product.getTruOriginCode())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.tnvedName.notNull}").addPropertyNode("productSet.products[" + i + "].tnvedName").addConstraintViolation();
                    hasError = true;
                }
                if (StringUtils.isEmpty(product.getUnitCode()) && valuesTruOriginCodeForMandatoryUnitCode.contains(product.getTruOriginCode())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.unitCode.notNull}").addPropertyNode("productSet.products[" + i + "].unitCode").addConstraintViolation();
                    hasError = true;
                }
                if (StringUtils.isEmpty(product.getUnitCode()) && invoice.isForExport() && countryIsEaecMember && "4".equals(product.getTruOriginCode())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.unitCode.notNull}").addPropertyNode("productSet.products[" + i + "].unitCode").addConstraintViolation();
                    hasError = true;
                }
                if (StringUtils.isEmpty(product.getUnitNomenclature()) && valuesTruOriginCodeForMandatoryUnitNomenclature.contains(product.getTruOriginCode())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.unitNomenclature.notNull}").addPropertyNode("productSet.products[" + i + "].unitNomenclature").addConstraintViolation();
                    hasError = true;
                }
                if (product.getQuantity() == null && valuesTruOriginCodeForMandatoryQuantity.contains(product.getTruOriginCode())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.quantity.notNull}").addPropertyNode("productSet.products[" + i + "].quantity").addConstraintViolation();
                    hasError = true;
                }
                if ("1".equals(product.getTruOriginCode())) {
                    if (StringUtils.isEmpty(product.getProductDeclaration())) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.notNull}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                        hasError = true;
                    } else {
                        if (StringUtils.isEmpty(product.getProductDeclaration()) || product.getProductDeclaration().length() != 18 && product.getProductDeclaration().length() != 20 && product.getProductDeclaration().length() != 42) {
                            context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.length.18.20.42}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                            hasError = true;
                        }
                        if (!(product.getProductDeclaration().length() != 18 || Pattern.matches("[0-9]{4}[0-9]{8}[NI]{1}[0-9]{5}", product.getProductDeclaration()) && DateTimeUtils.isDateValid(product.getProductDeclaration().substring(4, 12), "ddMMyyyy"))) {
                            context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.format.18.20.42}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                            hasError = true;
                        }
                        if (!(product.getProductDeclaration().length() != 20 || Pattern.matches("[0-9]{5}/[0-9]{6}/([0-9]{7}|B[0-9]{6})", product.getProductDeclaration()) && DateTimeUtils.isDateValid(product.getProductDeclaration().substring(6, 12), "ddMMyy"))) {
                            context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.format.18.20.42}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                            hasError = true;
                        }
                        if (product.getProductDeclaration().length() == 42 && !RegistrationNumberUtils.isSnt(product.getProductDeclaration())) {
                            context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.format.18.20.42}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                            hasError = true;
                        }
                    }
                }
                if ("2".equals(product.getTruOriginCode()) && product.getProductDeclaration() != null && product.getProductDeclaration().length() == 42) {
                    if (RegistrationNumberUtils.isSnt(product.getProductDeclaration())) {
                        if (!countryIsKZ && !countryIsEaecMember) {
                            context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.42.onlyKzOrEaec}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                            hasError = true;
                        }
                    } else {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.format.42}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                        hasError = true;
                    }
                }
                if (!"1".equals(product.getTruOriginCode()) && !"2".equals(product.getTruOriginCode()) && StringUtils.isNotEmpty(product.getProductDeclaration()) && product.getProductDeclaration().length() > 20) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.length.20}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                    hasError = true;
                }
                if ("3".equals(product.getTruOriginCode()) && invoice.isForExport() && countryIsEaecMember && StringUtils.isEmpty(product.getProductDeclaration())) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.length.11.13}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                    hasError = true;
                }
                if (("3".equals(product.getTruOriginCode()) || "4".equals(product.getTruOriginCode())) && !StringUtils.isEmpty(product.getProductDeclaration())) {
                    if (product.getProductDeclaration().length() != 11 && product.getProductDeclaration().length() != 13) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.length.11.13}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                        hasError = true;
                    }
                    if (product.getProductDeclaration().length() == 11 && !Pattern.matches("KZ[0-9]{9}", product.getProductDeclaration())) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.format.11.13}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                        hasError = true;
                    }
                    if (product.getProductDeclaration().length() == 13 && !Pattern.matches("KZ.{2}[0-9]{9}", product.getProductDeclaration())) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.invalid.format.11.13}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                        hasError = true;
                    }
                }
                if ("2".equals(product.getTruOriginCode()) && invoiceType == InvoiceType.ORDINARY_INVOICE && DateTimeUtils.greaterOrEquals(invoice.getDate(), DATE_010719)) {
                    if (StringUtils.isEmpty(product.getProductDeclaration())) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.productDeclaration.notNull}").addPropertyNode("productSet.products[" + i + "].productDeclaration").addConstraintViolation();
                        hasError = true;
                    }
                    if (StringUtils.isEmpty(product.getProductNumberInDeclaration())) {
                        context.buildConstraintViolationWithTemplate("{invoiceV2.product.productNumberInDeclaration.notNull}").addPropertyNode("productSet.products[" + i + "].productNumberInDeclaration").addConstraintViolation();
                        hasError = true;
                    }
                }
                if (!StringUtils.isEmpty(product.getProductNumberInDeclaration()) || !valuesTruOriginCodeForMandatoryProductNumberInDeclaration.contains(product.getTruOriginCode())) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.product.productNumberInDeclaration.notNull}").addPropertyNode("productSet.products[" + i + "].productNumberInDeclaration").addConstraintViolation();
                hasError = true;
            }
        }
        if (!this.checkQuantity(invoice, context, invoice.getSellerParticipants(), true)) {
            hasError = true;
        }
        if (!this.checkQuantity(invoice, context, invoice.getCustomerParticipants(), false)) {
            hasError = true;
        }
        return !hasError;
    }

    private boolean checkQuantity(InvoiceV2 invoice, ConstraintValidatorContext context, List<ParticipantV2> participants, boolean sellers) {
        if (participants != null && !participants.isEmpty()) {
            List<ProductV2> productList = invoice.getProductSet().getProducts();
            for (int i = 0; i < productList.size(); ++i) {
                ProductV2 p = productList.get(i);
                int productNum = i + 1;
                BigDecimal priceWithoutTax = BigDecimal.ZERO;
                BigDecimal turnoverSize = BigDecimal.ZERO;
                BigDecimal priceWithTax = BigDecimal.ZERO;
                BigDecimal ndsAmount = BigDecimal.ZERO;
                BigDecimal exciseAmount = BigDecimal.ZERO;
                BigDecimal quantitativeQuantity = BigDecimal.ZERO;
                for (int pi = 0; pi < participants.size(); ++pi) {
                    ParticipantV2 participant = participants.get(pi);
                    if (participant.getProductShares() == null) {
                        return true;
                    }
                    for (ProductShareV2 ps : participant.getProductShares()) {
                        if (ps.getProductNumber() != productNum) continue;
                        if (ps.getPriceWithoutTax() == null) {
                            return true;
                        }
                        if (ps.getTurnoverSize() == null) {
                            return true;
                        }
                        if (ps.getPriceWithTax() == null) {
                            return true;
                        }
                        if (ps.getNdsAmount() == null) {
                            return true;
                        }
                        if (ps.getQuantitativeQuantity() == null) {
                            return true;
                        }
                        priceWithoutTax = priceWithoutTax.add(ps.getPriceWithoutTax());
                        turnoverSize = turnoverSize.add(ps.getTurnoverSize());
                        priceWithTax = priceWithTax.add(ps.getPriceWithTax());
                        ndsAmount = ndsAmount.add(ps.getNdsAmount());
                        exciseAmount = exciseAmount.add(ProductDistributionValidatorV2.nvl(ps.getExciseAmount()));
                        quantitativeQuantity = quantitativeQuantity.add(ProductDistributionValidatorV2.nvl(ps.getQuantitativeQuantity()));
                        if (!sellers) continue;
                        SellerV2 seller = invoice.getSellers().get(pi);
                        if (StringUtils.isNotEmpty(seller.getCertificateSeries()) && StringUtils.isNotEmpty(seller.getCertificateNum())) {
                            if (Integer.valueOf(12).equals(p.getNdsRate())) {
                                if (VALID_NDS_RATES.contains(ps.getNdsRate())) continue;
                                context.buildConstraintViolationWithTemplate("{invoiceV2.products.sellers.ndsRate.invalid}").addPropertyNode("productSet.products[" + i + "].ndsRate").addConstraintViolation();
                                return false;
                            }
                            if (!ObjectUtils.notEqual(p.getNdsRate(), ps.getNdsRate())) continue;
                            context.buildConstraintViolationWithTemplate("{invoiceV2.products.sellers.ndsRate.notEquals}").addPropertyNode("productSet.products[" + i + "].ndsRate").addConstraintViolation();
                            return false;
                        }
                        if (ps.getNdsRate() == null) continue;
                        context.buildConstraintViolationWithTemplate("{invoiceV2.products.sellers.ndsRate.notNull}").addPropertyNode("productSet.products[" + i + "].ndsRate").addConstraintViolation();
                        return false;
                    }
                }
                if (p.getPriceWithoutTax() != null && priceWithoutTax.compareTo(p.getPriceWithoutTax()) != 0) {
                    String message = sellers ? "{invoiceV2.products.sellers.priceWithoutTax}" : "{invoiceV2.products.customers.priceWithoutTax}";
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].priceWithoutTax").addConstraintViolation();
                    return false;
                }
                if (p.getTurnoverSize() != null && turnoverSize.compareTo(p.getTurnoverSize()) != 0) {
                    String message = sellers ? "{invoiceV2.products.sellers.turnoverSize}" : "{invoiceV2.products.customers.turnoverSize}";
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].turnoverSize").addConstraintViolation();
                    return false;
                }
                if (sellers && p.getPriceWithTax() != null && priceWithTax.compareTo(p.getPriceWithTax()) != 0) {
                    String message = sellers ? "{invoiceV2.products.sellers.priceWithTax}" : "{invoiceV2.products.customers.priceWithTax}";
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].priceWithTax").addConstraintViolation();
                    return false;
                }
                if (sellers && p.getNdsAmount() != null && ndsAmount.compareTo(p.getNdsAmount()) != 0) {
                    String message = sellers ? "{invoiceV2.products.sellers.ndsAmount}" : "{invoiceV2.products.customers.ndsAmount}";
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].ndsAmount").addConstraintViolation();
                    return false;
                }
                if (exciseAmount.compareTo(ProductDistributionValidatorV2.nvl(p.getExciseAmount())) != 0) {
                    String message = sellers ? "{invoiceV2.products.sellers.exciseAmount}" : "{invoiceV2.products.customers.exciseAmount}";
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].exciseAmount").addConstraintViolation();
                    return false;
                }
                if (quantitativeQuantity.compareTo(ProductDistributionValidatorV2.nvl(p.getQuantitativeQuantity())) == 0) continue;
                String message = sellers ? "{invoiceV2.products.sellers.quantitativeQuantity}" : "{invoiceV2.products.customers.quantitativeQuantity}";
                context.buildConstraintViolationWithTemplate(message).addPropertyNode("productSet.products[" + i + "].quantitativeQuantity").addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    private boolean shareCheck(InvoiceV2 invoice, ConstraintValidatorContext context) {
        boolean result = true;
        if ((invoice.getCustomerParticipants() == null || invoice.getCustomerParticipants().isEmpty()) && (invoice.getSellerParticipants() == null || invoice.getSellerParticipants().isEmpty())) {
            return true;
        }
        if (invoice.getSellerParticipants() != null && !invoice.getSellerParticipants().isEmpty() && !invoice.getSellers().stream().anyMatch(seller -> seller.getShareParticipation() == null)) {
            List<BigDecimal> sellerShares = ((Stream)invoice.getSellers().stream().sequential()).filter(seller -> seller.getShareParticipation() != null).map(seller -> seller.getShareParticipation()).collect(Collectors.toList());
            boolean bl = result = result && this.checkParticipantShares(invoice.getProductSet(), invoice.getSellerParticipants(), sellerShares, true, context);
        }
        if (invoice.getCustomerParticipants() != null && !invoice.getCustomerParticipants().isEmpty() && !invoice.getCustomers().stream().anyMatch(customer -> customer.getShareParticipation() == null)) {
            List<BigDecimal> customerShares = ((Stream)invoice.getCustomers().stream().sequential()).filter(customer -> customer.getShareParticipation() != null).map(customer -> customer.getShareParticipation()).collect(Collectors.toList());
            result = result && this.checkParticipantShares(invoice.getProductSet(), invoice.getCustomerParticipants(), customerShares, false, context);
        }
        return result;
    }

    private boolean checkParticipantShares(ProductSetV2 productSet, List<ParticipantV2> participants, List<BigDecimal> shares, boolean isSellers, ConstraintValidatorContext context) {
        if (participants.size() != shares.size()) {
            return true;
        }
        BigDecimal totalPriceWithoutTax = productSet.getTotalPriceWithoutTax();
        BigDecimal totalShares = shares.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        int i = 0;
        for (ParticipantV2 participant : participants) {
            BigDecimal share;
            BigDecimal participantTotalPriceWithoutTax = participant.getProductShares().stream().map(p -> ProductDistributionValidatorV2.nvl(p.getPriceWithoutTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!DistributionUtils.checkShare(totalPriceWithoutTax, participantTotalPriceWithoutTax, totalShares, shares, share = shares.get(i), 2)) {
                String field = "totalPriceWithoutTax";
                String participantName = isSellers ? "seller" : "customer";
                String message = String.format("{invoiceV2.%sParticipant.%s.share.notEqual}", participantName, field);
                context.buildConstraintViolationWithTemplate(message).addPropertyNode(participantName + "Participant[" + i + "]." + field).addConstraintViolation();
                return false;
            }
            ++i;
        }
        return true;
    }

    private static BigDecimal nvl(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }
}

