/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.NdsRateTypeV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.validation.invoice.version.v2.ProductNdsRateTypeV2;
import ru.uss.vstore.utils.GsvsCodeUtils;

public class ProductNdsRateTypeValidatorV2
implements ConstraintValidator<ProductNdsRateTypeV2, InvoiceV2> {
    @Override
    public void initialize(ProductNdsRateTypeV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        if (invoice.getProductSet() != null && invoice.getProductSet().getProducts() != null && NdsRateTypeV2.WITHOUT_NDS_NOT_KZ.equals((Object)invoice.getProductSet().getNdsRateType())) {
            for (int i = 0; i < invoice.getProductSet().getProducts().size(); ++i) {
                ProductV2 productV2 = invoice.getProductSet().getProducts().get(i);
                if (productV2 == null || !GsvsCodeUtils.isValidGsvsExtendedCode(productV2.getCatalogTruId())) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.product.withoutNdsNotKz.hasValid.catalogTru}").addPropertyNode("productSet.products[" + i + "].catalogTruId").addConstraintViolation();
                result = false;
            }
        }
        return result;
    }
}

