/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.RelatedNumV2;

public class RelatedNumValidatorV2
implements ConstraintValidator<RelatedNumV2, InvoiceV2> {
    @Override
    public void initialize(RelatedNumV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getRelatedInvoice() != null && StringUtils.isEmpty(invoice.getRelatedInvoice().getNum()) && invoice.getInvoiceType() != null) {
            if (invoice.getInvoiceType().equals(InvoiceType.ADDITIONAL_INVOICE)) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.additional.relatedInvoice.num.notNull}").addPropertyNode("relatedInvoice.num").addConstraintViolation();
            } else if (invoice.getInvoiceType().equals(InvoiceType.FIXED_INVOICE)) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.fixed.relatedInvoice.num.notNull}").addPropertyNode("relatedInvoice.num").addConstraintViolation();
            } else {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.num.notNull}").addPropertyNode("relatedInvoice.num").addConstraintViolation();
            }
            return false;
        }
        return true;
    }
}

