/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Calendar;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.RelatedRegistrationNumberV2;

public class RelatedRegistrationNumberValidatorV2
implements ConstraintValidator<RelatedRegistrationNumberV2, InvoiceV2> {
    @Override
    public void initialize(RelatedRegistrationNumberV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getRelatedInvoice() != null && invoice.getRelatedInvoice().getDate() != null && StringUtils.isEmpty(invoice.getRelatedInvoice().getRegistrationNumber())) {
            if (invoice.getInvoiceType() == InvoiceType.FIXED_INVOICE) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.fixed.relatedInvoice.registrationNumber.notNull}").addConstraintViolation();
            } else if (invoice.getInvoiceType() == InvoiceType.ADDITIONAL_INVOICE) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.additional.relatedInvoice.registrationNumber.notNull}").addConstraintViolation();
            } else {
                context.buildConstraintViolationWithTemplate("{invoiceV2.additional.relatedInvoice.registrationNumber.notNull}").addConstraintViolation();
            }
            return false;
        }
        if (invoice.getInvoiceType() == InvoiceType.FIXED_INVOICE || invoice.getInvoiceType() == InvoiceType.ADDITIONAL_INVOICE) {
            if (invoice.getRelatedInvoice() == null || invoice.getRelatedInvoice().getDate() == null) {
                return true;
            }
            Date parentDate = DateTimeUtils.startOfTheDay(invoice.getRelatedInvoice().getDate());
            Date childDate = DateTimeUtils.startOfTheDay(invoice.getDate());
            Calendar cal = Calendar.getInstance();
            cal.setTime(childDate);
            cal.add(1, -5);
            Date dateMinus5Years = cal.getTime();
            if (parentDate.compareTo(dateMinus5Years) < 0) {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.date.tooFar}").addConstraintViolation();
                return false;
            }
            if (parentDate.compareTo(childDate) > 0) {
                context.buildConstraintViolationWithTemplate("{relatedInvoice.date.afterChild}").addPropertyNode("date").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

