/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.SellerStatusV2;

public class SellerStatusValidatorV2
implements ConstraintValidator<SellerStatusV2, InvoiceV2> {
    private List<CustomerTypeV2> RETAIL_NOT_ALLOWED_WITH_EXPORTER = Arrays.asList(CustomerTypeV2.COMMITTENT, CustomerTypeV2.BROKER, CustomerTypeV2.JOINT_ACTIVITY_PARTICIPANT, CustomerTypeV2.PUBLIC_OFFICE, CustomerTypeV2.NONRESIDENT);

    @Override
    public void initialize(SellerStatusV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        boolean exporterNotAllowed;
        context.disableDefaultConstraintViolation();
        if (CollectionUtils.isNotEmpty(invoice.getSellers()) && CollectionUtils.isNotEmpty(invoice.getCustomers()) && (exporterNotAllowed = invoice.getCustomers().stream().filter(c -> CollectionUtils.isNotEmpty(c.getStatuses())).filter(c -> c.getStatuses().size() > 1).anyMatch(c -> c.getStatuses().contains(CustomerTypeV2.RETAIL) && CollectionUtils.containsAny(this.RETAIL_NOT_ALLOWED_WITH_EXPORTER, c.getStatuses())))) {
            for (int i = 0; i < invoice.getSellers().size(); ++i) {
                if (!invoice.getSellers().get(i).containsStatus(SellerTypeV2.EXPORTER)) continue;
                context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.status.exporter.notAllowed}").addPropertyNode(String.format("sellers[%d].statuses", i)).addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

