/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.model.invoice.version.v2.SellerV2;
import ru.uss.esf.validation.invoice.version.v2.SellersParticipantsV2;

public class SellersParticipantsValidatorV2
implements ConstraintValidator<SellersParticipantsV2, List<SellerV2>> {
    @Override
    public void initialize(SellersParticipantsV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(List<SellerV2> sellers, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (sellers == null || sellers.isEmpty()) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.notEmpty}").addConstraintViolation();
            return false;
        }
        ArrayList<String> tins = new ArrayList<String>();
        for (int i = 0; i < sellers.size(); ++i) {
            SellerV2 seller = sellers.get(i);
            if (seller == null) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.elementIsNull}").addConstraintViolation();
                return false;
            }
            if (sellers.size() == 1 && seller.getStatuses() != null && seller.getStatuses().contains(SellerTypeV2.JOINT_ACTIVITY_PARTICIPANT)) {
                context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.singleIsNotParticipant}").addConstraintViolation();
                return false;
            }
            if (sellers.size() > 1) {
                boolean allHasJointActivityParticipant = sellers.stream().allMatch(c -> c.getStatuses() != null && c.getStatuses().contains(SellerTypeV2.JOINT_ACTIVITY_PARTICIPANT));
                boolean allHasSharingAgreementParticipant = sellers.stream().allMatch(c -> c.getStatuses() != null && c.getStatuses().contains(SellerTypeV2.SHARING_AGREEMENT_PARTICIPANT));
                if (!allHasJointActivityParticipant && !allHasSharingAgreementParticipant) {
                    context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.oneIsNotParticipant}").addConstraintViolation();
                    return false;
                }
            }
            tins.add(seller.getTin());
        }
        if (tins.size() != new HashSet(tins).size()) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.sellers.duplicatedTin}").addConstraintViolation();
            return false;
        }
        return true;
    }
}

