/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.time.DateUtils;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.validation.invoice.version.v2.TurnoverDateV2;

public class TurnoverDateValidatorV2
implements ConstraintValidator<TurnoverDateV2, InvoiceV2> {
    @Override
    public void initialize(TurnoverDateV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        Date date;
        context.disableDefaultConstraintViolation();
        if (invoice.getTurnoverDate() == null || invoice.getDate() == null) {
            return true;
        }
        Date turnoverDate = DateUtils.truncate(invoice.getTurnoverDate(), 5);
        if (turnoverDate.after(date = DateUtils.truncate(invoice.getDate(), 5))) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.turnoverDate.incorrect}").addPropertyNode("turnoverDate").addConstraintViolation();
            return false;
        }
        return true;
    }
}

