/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2.field;

import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.field.SellerTypesV2;

public class SellerTypesValidatorV2
implements ConstraintValidator<SellerTypesV2, List<SellerTypeV2>> {
    @Override
    public void initialize(SellerTypesV2 constraintAnnotation) {
    }

    @Override
    public boolean isValid(List<SellerTypeV2> statusList, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (statusList != null) {
            if (statusList.isEmpty()) {
                context.buildConstraintViolationWithTemplate("{sellerV2.statuses.emptyList}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(null)) {
                context.buildConstraintViolationWithTemplate("{sellerV2.statuses.containsNull}").addConstraintViolation();
                return false;
            }
            if (statusList.size() == 1) {
                return true;
            }
            if (statusList.size() != new HashSet<SellerTypeV2>(statusList).size()) {
                context.buildConstraintViolationWithTemplate("{sellerV2.statuses.isDuplicated}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(SellerTypeV2.COMMITTENT) && statusList.contains(SellerTypeV2.BROKER)) {
                context.buildConstraintViolationWithTemplate("{sellerV2.statuses.multipleMutualExclusive}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(SellerTypeV2.SHARING_AGREEMENT_PARTICIPANT) && statusList.contains(SellerTypeV2.JOINT_ACTIVITY_PARTICIPANT)) {
                context.buildConstraintViolationWithTemplate("{sellerV2.statuses.sharedMultipleMutualExclusive}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

