/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Date;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.SntActionType;
import ru.uss.esf.model.snt.abstractsnt.AbstractSntOgdMarks;
import ru.uss.esf.model.snt.version.v1.SntActionV1;
import ru.uss.esf.validation.snt.version.v1.SntActionCheckV1;

public class SntActionValidatorV1
extends AbstractClassLevelValidator<SntActionCheckV1, SntActionV1> {
    @Override
    public void initialize(SntActionCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntActionV1 value, ConstraintValidatorContext context) {
        SntActionType actionType = value.getActionType();
        if (actionType == null) {
            return true;
        }
        switch (actionType) {
            case CREATE: 
            case VIEW: 
            case CANCEL: {
                return this.setupContextWithValidationError(context, "{sntActionV1.invalidActionType}");
            }
            case CONFIRM: {
                return this.validateFields(context, value, true, false, false);
            }
            case CONFIRM_BY_OGD: 
            case EDIT_BY_OGD: {
                return this.validateFields(context, value, false, true, false);
            }
            case DECLINE_BY_OGD: 
            case DECLINE: 
            case REVOKE: 
            case CANCEL_CONFIRM: {
                return this.validateFields(context, value, false, false, true);
            }
            case DELETE: {
                return this.validateFields(context, value, false, false, false);
            }
        }
        return false;
    }

    private boolean validateFields(ConstraintValidatorContext context, SntActionV1 value, boolean powerOfAttorneyEnable, boolean ogdMarksEnable, boolean causeEnable) {
        AbstractSntOgdMarks ogdMarks;
        boolean isValid = true;
        Date powerOfAttorneyDate = value.getPowerOfAttorneyDate();
        String powerOfAttorneyNumber = value.getPowerOfAttorneyNumber();
        if (!powerOfAttorneyEnable) {
            if (powerOfAttorneyDate != null) {
                isValid = this.setupContextWithValidationError(context, "powerOfAttorneyDate", this.generateNullFieldMessage("sntActionV1.powerOfAttorneyDate"));
            }
            if (powerOfAttorneyNumber != null) {
                isValid = this.setupContextWithValidationError(context, "powerOfAttorneyNumber", this.generateNullFieldMessage("sntActionV1.powerOfAttorneyNumber"));
            }
        } else {
            boolean numberNull;
            boolean dateNull = powerOfAttorneyDate == null;
            if (dateNull != (numberNull = StringUtils.isEmpty(powerOfAttorneyNumber))) {
                isValid = this.setupContextWithValidationError(context, "{sntActionV1.powerOfAttorneyDateAndNumber.invalid}");
            }
        }
        if ((ogdMarks = value.getOgdMarks()) != null && !ogdMarksEnable) {
            isValid = this.setupContextWithValidationError(context, "ogdMarks", this.generateNullFieldMessage("sntActionV1.ogdMarks"));
        } else if (ogdMarks == null && ogdMarksEnable) {
            isValid = this.setupContextWithValidationError(context, "ogdMarks", this.generateNotNullFieldMessage("sntActionV1.ogdMarks"));
        }
        String cause = value.getCause();
        if (cause != null && !causeEnable) {
            isValid = this.setupContextWithValidationError(context, "cause", this.generateNullFieldMessage("sntActionV1.cause"));
        } else if (cause == null && causeEnable) {
            isValid = this.setupContextWithValidationError(context, "cause", this.generateNotNullFieldMessage("sntActionV1.cause"));
        }
        return isValid;
    }
}

