/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.EsfModelCollectionUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntBiofuelSetV1;
import ru.uss.esf.model.snt.version.v1.SntCustomerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntBiofuelSetCheckV1;

public class SntBiofuelSetValidatorV1
extends AbstractClassLevelValidator<SntBiofuelSetCheckV1, SntV1> {
    private static final List<String> emptyCodeOperationsBySellerType = Arrays.asList("6", "7", "8");
    private static final Map<String, List<String>> sellerTypeOpCodeMap = new HashMap<String, List<String>>();

    @Override
    public void initialize(SntBiofuelSetCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        String sellerTin;
        boolean isIndividual;
        SntBiofuelSetV1 biofuelSet = snt.getBiofuelSet();
        if (biofuelSet == null) {
            return true;
        }
        boolean result = true;
        boolean isTransfer = snt.getTransferType() != null;
        SntType sntType = snt.getSntType();
        String sellerType = biofuelSet.getProductSellerType();
        String opCode = biofuelSet.getOperationCode();
        boolean isExport = snt.getSntExport() != null;
        boolean isImport = snt.getSntImport() != null;
        boolean isTransferOnePersonInEAEU = SntTransferTypeV1.ONE_PERSON_IN_EAEU.equals(snt.getTransferType());
        boolean isTransferOnePersonInKZ = SntTransferTypeV1.ONE_PERSON_IN_KZ.equals(snt.getTransferType());
        boolean isRetail = snt.getCustomer() != null && snt.getCustomer().isRetail();
        boolean bl = isIndividual = snt.getCustomer() != null && snt.getCustomer().isIndividual();
        if (!isTransferOnePersonInEAEU && !isImport && sellerType == null) {
            result = this.setupContextWithValidationError(context, "biofuelSet.sellerType", "{sntBiofuelSetV1.productSellerType.notNull}");
        }
        if ((sellerType != null && emptyCodeOperationsBySellerType.contains(sellerType) || isExport || isRetail) && opCode != null) {
            result = this.setupContextWithValidationError(context, "biofuelSet.operationCode", "{sntBiofuelSetV1.operationCode.mustBeNull}");
        }
        if (sntType != SntType.RETURNED_SNT) {
            boolean isNotRequireOperationCode;
            boolean bl2 = isNotRequireOperationCode = isImport || isExport || isTransfer;
            if (!(isNotRequireOperationCode || opCode != null || sellerType != null && emptyCodeOperationsBySellerType.contains(sellerType) || isExport || isRetail)) {
                result = this.setupContextWithValidationError(context, "biofuelSet.operationCode", "{sntBiofuelSetV1.operationCode.notNull}");
            }
            if ("6".equals(sellerType) && !isTransferOnePersonInKZ) {
                result = this.setupContextWithValidationError(context, "biofuelSet.sellerType", "{sntBiofuelSetV1.productSellerType.incorrect}");
            }
            if (sellerType == null && opCode != null) {
                result = this.setupContextWithValidationError(context, "biofuelSet.operationCode", "{sntBiofuelSetV1.operationCode.unknown}");
            } else {
                List<String> allowedOpCodeList = sellerTypeOpCodeMap.get(sellerType);
                if (!isNotRequireOperationCode && StringUtils.isEmpty(opCode) || StringUtils.isNotEmpty(opCode) && !EsfModelCollectionUtils.nullSafeContainsAny(allowedOpCodeList, opCode)) {
                    result = this.setupContextWithValidationError(context, "biofuelSet.operationCode", "{sntBiofuelSetV1.operationCode.unknown}");
                }
            }
        }
        if (snt.getCustomer() != null && BooleanUtils.isTrue(snt.getCustomer().getNonResident()) && "4".equals(sellerType)) {
            result = this.setupContextWithValidationError(context, "biofuelSet.sellerType", "{sntBiofuelSetV1.productSellerType.incorrect}");
        }
        if (StringUtils.isNotEmpty(sellerTin = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getSeller().getTin())) && StringUtils.isEmpty(biofuelSet.getKogdOfSender())) {
            result = this.setupContextWithValidationError(context, "biofuelSet.kogdOfSender", "{sntBiofuelSetV1.kogdOfSender.notNull}");
        }
        if (!(!StringUtils.isEmpty(biofuelSet.getKogdOfRecipient()) || snt.getCustomer() != null && BooleanUtils.isTrue(snt.getCustomer().getNonResident()) || isIndividual || isRetail || "34".equals(opCode))) {
            result = this.setupContextWithValidationError(context, "biofuelSet.kogdOfRecipient", "{sntBiofuelSetV1.kogdOfRecipient.notNull}");
        }
        if (!this.validateForSmallRetailOutlet(snt, context)) {
            result = false;
        }
        return result;
    }

    private boolean validateForSmallRetailOutlet(SntV1 snt, ConstraintValidatorContext context) {
        String operationCode;
        boolean result = true;
        if ((snt.getSntType() == SntType.PRIMARY_SNT || snt.getSntType() == SntType.FIXED_SNT) && snt.getCustomer() != null && snt.getCustomer().containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET) && StringUtils.isNotEmpty(operationCode = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getBiofuelSet().getOperationCode()))) {
            result = this.setupContextWithValidationError(context, "biofuelSet.operationCode", "{sntBiofuelSetV1.operationCode.smallRetailOutlet.mustBeNull}");
        }
        return result;
    }

    static {
        sellerTypeOpCodeMap.put("1", Arrays.asList("30", "31", "34", "37"));
        sellerTypeOpCodeMap.put("4", Arrays.asList("37"));
    }
}

