/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntCustomerCountryCodeCheckV1;

public class SntCustomerCountryCodeValidatorV1
extends AbstractClassLevelValidator<SntCustomerCountryCodeCheckV1, SntV1> {
    private static final List<SntExportTypeV1> needNoKzExportTypes = Arrays.asList(SntExportTypeV1.EXPORT, SntExportTypeV1.EXPORT_FOR_PROCESSING, SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT, SntExportTypeV1.TEMPORARY_EXPORT, SntExportTypeV1.AIRCRAFT_REFUELING);

    @Override
    public void initialize(SntCustomerCountryCodeCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        if (sntV1.getCustomer() == null) {
            return true;
        }
        SntImportTypeV1 sntImportType = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType());
        SntExportTypeV1 sntExportType = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType());
        Boolean customerNonResident = BooleanUtils.isTrue(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getCustomer().getNonResident()));
        if ((SntImportTypeV1.IMPORT_IN_SEZ.equals(sntImportType) || SntExportTypeV1.EXPORT_FROM_SEZ.equals(sntExportType) && !customerNonResident.booleanValue()) && !"KZ".equals(sntV1.getCustomer().getCountryCode())) {
            return this.setupContextWithValidationError(context, "customer.countryCode", "{sntParticipantV1.SEZ.countryCode.notKZ}");
        }
        if ((SntImportTypeV1.importTypesWithoutSez().contains(sntImportType) || sntV1.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_KZ) && !"KZ".equals(sntV1.getCustomer().getCountryCode())) {
            return this.setupContextWithValidationError(context, "customer.countryCode", "{sntCustomerV1.countryCode.onlyKZ}");
        }
        if (sntV1.getSntExport() != null && sntV1.getSntExport().getExportType() != null && (needNoKzExportTypes.contains(sntV1.getSntExport().getExportType()) || SntExportTypeV1.EXPORT_FROM_SEZ.equals(sntExportType) && customerNonResident.booleanValue()) && "KZ".equals(sntV1.getCustomer().getCountryCode())) {
            return this.setupContextWithValidationError(context, "customer.countryCode", "{sntCustomerV1.countryCode.notKZ}");
        }
        if (sntV1.getSntExport() == null && sntV1.getTransferType() == null && !"KZ".equals(sntV1.getCustomer().getCountryCode())) {
            return this.setupContextWithValidationError(context, "customer.countryCode", "{sntCustomerV1.countryCode.onlyKZ}");
        }
        return true;
    }
}

