/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntCustomerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntCustomerV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntCustomerStatusCheckV1;

public class SntCustomerStatusValidatorV1
extends AbstractClassLevelValidator<SntCustomerStatusCheckV1, SntV1> {
    private static final List<SntImportTypeV1> sntImportTypes = Arrays.asList(SntImportTypeV1.IMPORT, SntImportTypeV1.IMPORT_FOR_PROCESSING, SntImportTypeV1.TEMPORARY_IMPORT, SntImportTypeV1.IMPORT_OF_TEMPORARY_EXPORTED_PRODUCT);
    private static final List<SntCustomerTypeV1> excludeCustomerTransferTypes = Collections.unmodifiableList(Arrays.asList(SntCustomerTypeV1.LAWYER, SntCustomerTypeV1.NOTARY, SntCustomerTypeV1.MEDIATOR, SntCustomerTypeV1.BAILIFF, SntCustomerTypeV1.INDIVIDUAL, SntCustomerTypeV1.RETAIL, SntCustomerTypeV1.RETAILER, SntCustomerTypeV1.PHARMACEUTIC_PRODUCER, SntCustomerTypeV1.LESSEE, SntCustomerTypeV1.LESSOR, SntCustomerTypeV1.COMMITTENT, SntCustomerTypeV1.BROKER));

    @Override
    public void initialize(SntCustomerStatusCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        SntCustomerV1 customer = sntV1.getCustomer();
        if (customer == null) {
            return true;
        }
        if (customer.getStatuses() == null) {
            return true;
        }
        if (!(customer.getStatuses().stream().filter(SntCustomerTypeV1::hasPredefinedParticipantType).count() <= 1L || customer.getStatuses().stream().filter(SntCustomerTypeV1::hasPredefinedParticipantType).count() == 2L && customer.getStatuses().contains(SntCustomerTypeV1.INDIVIDUAL) && customer.getStatuses().contains(SntCustomerTypeV1.RETAIL))) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.invalid}");
        }
        if (sntV1.getSntType() == SntType.PRIMARY_SNT || sntV1.getSntType() == SntType.FIXED_SNT) {
            if (customer.isLessor()) {
                return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.LESSOR.blocked}");
            }
            if (customer.isLessee() && sntV1.getSeller() != null && !sntV1.getSeller().isLessor()) {
                return this.setupContextWithValidationError(context, "customer.status", "{sntSellerV1.status.LESSOR.not.picked}");
            }
        }
        if (sntV1.getSntType() == SntType.RETURNED_SNT && sntV1.isCustomerRetailer()) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.RETAILER.blocked.for.returned}");
        }
        boolean hasImportTypeForCheck = sntImportTypes.contains(LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getSntImport().getImportType()));
        List customerStatuses = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getCustomer().getStatuses(), Collections.emptyList());
        if ((hasImportTypeForCheck || sntV1.getTransferType() != null) && customerStatuses.contains(SntCustomerTypeV1.RETAILER)) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.RETAILER.blocked.for.import}");
        }
        if (sntV1.getTransferType() != null && sntV1.getCustomer() != null && CollectionUtils.isNotEmpty(sntV1.getCustomer().getStatuses()) && CollectionUtils.containsAny(excludeCustomerTransferTypes, sntV1.getCustomer().getStatuses())) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.INDIVIDUAL.blocked.for.transfer}");
        }
        if (sntV1.getSeller() != null && sntV1.getCustomer() != null && (sntV1.getSeller().isBroker() && sntV1.getCustomer().isBroker() || sntV1.getSeller().isCommittent() && sntV1.getCustomer().isCommittent())) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.incompatibleWithSeller}");
        }
        SntCustomerV1 customerV1 = sntV1.getCustomer();
        if (customerV1 != null && customerV1.containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET) && customerV1.getStatuses().size() > 1) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.SMALL_RETAIL_OUTLET.onlyOne}");
        }
        if ((sntV1.getSntImport() != null || sntV1.getSntExport() != null || sntV1.getTransferType() != null) && customerV1 != null && customerV1.containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET)) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.SMALL_RETAIL_OUTLET.exportImportTransfer.denied}");
        }
        if (customer.isPawneeCustodian()) {
            if (sntV1.getSntType() != SntType.RETURNED_SNT) {
                return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.PAWNEE_CUSTODIAN.RETURNED_SNT.denied}");
            }
            if (customer.getParticipantType() != DocumentParticipantType.BUSINESS) {
                return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.PAWNEE_CUSTODIAN.BUSINESS.allowed}");
            }
            if (customer.getStatuses().size() > 1) {
                return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.PAWNEE_CUSTODIAN.alone}");
            }
            if (sntV1.getTransferType() != null) {
                return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.PAWNEE_CUSTODIAN.transferType.denied}");
            }
        }
        if (LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getSntExport().getExportType()) == SntExportTypeV1.EXPORT && sntV1.isCustomerRetail() && BooleanUtils.isTrue(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getCustomer().getNonResident()))) {
            return this.setupContextWithValidationError(context, "customer.status", "{sntCustomerV1.status.RETAIL.export.nonResident.denied}");
        }
        return true;
    }
}

