/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.validation.snt.version.v1.SntDeclarationNumberFormatV1;

public class SntDeclarationNumberFormatValidatorV1
extends AbstractClassLevelValidator<SntDeclarationNumberFormatV1, SntAbstractProduct> {
    private String declarationNumberField;
    private String truOriginCodeField;

    @Override
    public void initialize(SntDeclarationNumberFormatV1 constraintAnnotation) {
        this.declarationNumberField = constraintAnnotation.declarationNumberField();
        this.truOriginCodeField = constraintAnnotation.truOriginCodeField();
    }

    @Override
    public boolean isValid(SntAbstractProduct sntProduct, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        String declarationNumber = sntProduct.getDeclarationNumberForSnt();
        String truOriginCode = sntProduct.getTruOriginCode();
        if (StringUtils.isEmpty(truOriginCode)) {
            return true;
        }
        if (StringUtils.isEmpty(declarationNumber)) {
            return true;
        }
        if ("1".equals(truOriginCode) || "2".equals(truOriginCode)) {
            if (declarationNumber.length() == 18) {
                if (!Pattern.matches("[0-9]{4}[0-9]{8}[NI]{1}[0-9]{5}", declarationNumber) || !DateTimeUtils.isDateValid(declarationNumber.substring(4, 12), "ddMMyyyy")) {
                    context.buildConstraintViolationWithTemplate("{sntV1.products.declarationNumberField.incorrectFormat.18}").addPropertyNode(this.declarationNumberField).addConstraintViolation();
                    return false;
                }
            } else if (declarationNumber.length() == 20) {
                if (!(RegistrationNumberUtils.isZvt(declarationNumber) || Pattern.matches("[0-9]{5}/[0-9]{6}/[0-9]{7}", declarationNumber) && DateTimeUtils.isDateValid(declarationNumber.substring(6, 12), "ddMMyy"))) {
                    context.buildConstraintViolationWithTemplate("{sntV1.products.declarationNumberField.incorrectFormat.20}").addPropertyNode(this.declarationNumberField).addConstraintViolation();
                    return false;
                }
            } else if (declarationNumber.length() == 42) {
                if (!Pattern.matches("KZ-SNT-[0-9]{4}-[0-9]{12}-[0-9]{8}-[0-9]{8}", declarationNumber) || !DateTimeUtils.isDateValid(declarationNumber.substring(25, 33), "yyyyMMdd")) {
                    context.buildConstraintViolationWithTemplate("{sntV1.products.declarationNumberField.incorrectFormat.42}").addPropertyNode(this.declarationNumberField).addConstraintViolation();
                    return false;
                }
            } else {
                context.buildConstraintViolationWithTemplate("{sntV1.products.declarationNumberField.incorrectLength.18.20.42}").addPropertyNode(this.declarationNumberField).addConstraintViolation();
                return false;
            }
        }
        if (("3".equals(truOriginCode) || "4".equals(truOriginCode)) && !StringUtils.isEmpty(declarationNumber)) {
            if (declarationNumber.length() == 11) {
                if (!Pattern.matches("KZ[0-9]{9}", declarationNumber)) {
                    context.buildConstraintViolationWithTemplate("{sntV1.products.declarationNumberField.incorrectFormat.11}").addPropertyNode(this.declarationNumberField).addConstraintViolation();
                    return false;
                }
            } else if (declarationNumber.length() == 13) {
                if (!Pattern.matches("KZ.{2}[0-9]{9}", declarationNumber)) {
                    context.buildConstraintViolationWithTemplate("{sntV1.products.declarationNumberField.incorrectFormat.13}").addPropertyNode(this.declarationNumberField).addConstraintViolation();
                    return false;
                }
            } else {
                context.buildConstraintViolationWithTemplate("{sntV1.products.declarationNumberField.incorrectLength.11.13}").addPropertyNode(this.declarationNumberField).addConstraintViolation();
                return false;
            }
        }
        return result;
    }
}

