/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntDigitalMarkingMptCheckV1;

public class SntDigitalMarkingMptValidatorV1
extends AbstractClassLevelValidator<SntDigitalMarkingMptCheckV1, SntV1> {
    @Override
    public void initialize(SntDigitalMarkingMptCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext constraintValidatorContext) {
        if (sntV1 == null) {
            return true;
        }
        if (StringUtils.isEmpty(sntV1.getDigitalMarkingNotificationNumber())) {
            return true;
        }
        if (!RegistrationNumberUtils.isUUID(sntV1.getDigitalMarkingNotificationNumber())) {
            return this.setupContextWithValidationError(constraintValidatorContext, "digitalMarkingNotificationNumber", "{SNT_DIGITAL_MARKING_INVALID}");
        }
        if (sntV1.getDigitalMarkingNotificationDate() == null) {
            return this.setupContextWithValidationError(constraintValidatorContext, "digitalMarkingNotificationDate", "{abstractSnt.relatedRegistrationNumber.incorrect}");
        }
        return true;
    }
}

