/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.utils.MimeTypeFileUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.SntAttachedFile;
import ru.uss.esf.model.snt.SntAttachedFileType;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntExportControlProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntExportControlProductV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntExportControlSetCheckV1;

public class SntExportControlSetValidatorV1
extends AbstractClassLevelValidator<SntExportControlSetCheckV1, SntV1> {
    private static final List<SntExportTypeV1> ATTACHMENT_EXPORT_TYPES = Arrays.asList(SntExportTypeV1.EXPORT, SntExportTypeV1.EXPORT_FOR_PROCESSING, SntExportTypeV1.TEMPORARY_EXPORT, SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT, SntExportTypeV1.EXPORT_FROM_SEZ);
    private static final List<SntImportTypeV1> ATTACHMENT_IMPORT_TYPES = Arrays.asList(SntImportTypeV1.values());

    @Override
    public void initialize(SntExportControlSetCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        boolean isExport;
        SntExportControlProductSetV1 exportControlProductSet = snt.getExportControlProductSet();
        if (exportControlProductSet == null || CollectionUtils.isEmpty(exportControlProductSet.getProducts()) || snt.getDate() == null) {
            return true;
        }
        boolean result = true;
        boolean isImport = snt.getSntImport() != null && SntImportTypeV1.IMPORT.equals(snt.getSntImport().getImportType());
        boolean bl = isExport = snt.getSntExport() != null && SntExportTypeV1.EXPORT.equals(snt.getSntExport().getExportType());
        if (CollectionUtils.isEmpty(exportControlProductSet.getProducts()) && !isImport && !isExport) {
            result = this.setupContextWithValidationError(context, "sntExport", "{sntV1.exportControl.requireImpotOrExport}");
        }
        Date sntDate = snt.getDate();
        for (int i = 0; i < exportControlProductSet.getProducts().size(); ++i) {
            SntExportControlProductV1 product = exportControlProductSet.getProducts().get(i);
            if (product.getPermissiveDocumentExpireDate() == null || !DateTimeUtils.greaterOrEquals(sntDate, DateTimeUtils.plusDays(DateTimeUtils.startOfTheDay(product.getPermissiveDocumentExpireDate()), 1))) continue;
            result = this.setupContextWithValidationError(context, SntProductTypeV1.EXPORT_CONTROL_PRODUCT.getProductsPath() + String.format("[%d].permissiveDocumentExpireDate", i), "{sntExportControlProductV1.permissiveDocumentExpireDate.expired}");
        }
        if (exportControlProductSet.getPermitDocuments() != null) {
            boolean isValidTransferType;
            SntExportTypeV1 sntExportTypeV1 = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getSntExport().getExportType());
            SntImportTypeV1 sntImportTypeV1 = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getSntImport().getImportType());
            SntTransferTypeV1 transferType = snt.getTransferType();
            boolean isValidExportType = ATTACHMENT_EXPORT_TYPES.contains(sntExportTypeV1);
            boolean isValidImportType = ATTACHMENT_IMPORT_TYPES.contains(sntImportTypeV1);
            boolean bl2 = isValidTransferType = transferType == SntTransferTypeV1.ONE_PERSON_IN_EAEU;
            if ((snt.getSntType() == SntType.PRIMARY_SNT || snt.getSntType() == SntType.FIXED_SNT) && (isValidExportType || isValidImportType || isValidTransferType)) {
                HashSet existsIds = new HashSet();
                for (int i = 0; i < exportControlProductSet.getPermitDocuments().size(); ++i) {
                    String mimeType;
                    SntAttachedFileType fileType;
                    SntAttachedFile sntAttachedFile = exportControlProductSet.getPermitDocuments().get(i);
                    if (sntAttachedFile == null) continue;
                    if (sntAttachedFile.getData() != null && sntAttachedFile.getData().length > 358400) {
                        result = this.setupContextWithValidationError(context, SntProductTypeV1.EXPORT_CONTROL_PRODUCT.getProductsPath() + String.format(".permitDocuments[%d].data", i), "{sntV1.exportControl.permitDocument.fileSize}");
                    }
                    if (existsIds.contains(sntAttachedFile.getId())) {
                        result = this.setupContextWithValidationError(context, SntProductTypeV1.EXPORT_CONTROL_PRODUCT.getProductsPath() + String.format(".permitDocuments[%d].id", i), "{sntV1.exportControl.permitDocument.uniqueIdRequired}");
                    }
                    if ((fileType = SntAttachedFileType.getByMimeType(mimeType = MimeTypeFileUtils.detectMimeType(sntAttachedFile.getData()))) != null) continue;
                    result = this.setupContextWithValidationError(context, SntProductTypeV1.EXPORT_CONTROL_PRODUCT.getProductsPath() + String.format(".permitDocuments[%d].data", i), "{sntV1.exportControl.permitDocument.fileTypeNotSupported}");
                }
            } else {
                result = this.setupContextWithValidationError(context, SntProductTypeV1.EXPORT_CONTROL_PRODUCT.getProductsPath() + ".permitDocuments", "{sntV1.exportControl.permitDocuments.mustBeNull}");
            }
        }
        return result;
    }
}

