/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntCustomerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntExportV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportV1;
import ru.uss.esf.model.snt.version.v1.SntOilSetV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntOilSetCheckV1;

public class SntOilSetValidatorV1
extends AbstractClassLevelValidator<SntOilSetCheckV1, SntV1> {
    private static final List<String> emptyCodeOperationsBySellerType = Arrays.asList("6", "7", "8");
    private static final Map<String, List<String>> sellerTypeOpCodeMap = new HashMap<String, List<String>>();
    private static final List<SntImportTypeV1> importTypesWithoutSez;

    @Override
    public void initialize(SntOilSetCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        Boolean customerNonResident;
        boolean kogdNotRequiredForOnePersonEAEUTransfer;
        boolean isSellerBroker;
        SntOilSetV1 oilSet = snt.getOilSet();
        if (oilSet == null) {
            return true;
        }
        boolean isValid = true;
        SntType sntType = snt.getSntType();
        String opCode = oilSet.getOperationCode();
        String productSellerType = oilSet.getProductSellerType();
        SntImportV1 sntImport = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getSntImport());
        SntImportTypeV1 sntImportType = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getSntImport().getImportType());
        SntExportV1 sntExport = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getSntExport());
        SntTransferTypeV1 transferType = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getTransferType());
        boolean isOnePersonInKz = SntTransferTypeV1.ONE_PERSON_IN_KZ.equals(transferType);
        boolean isSellerNonResident = BooleanUtils.isTrue(LambdaUtils.nullSafeApplyFunction(snt, s -> s.getSeller().getNonResident()));
        boolean isRetail = snt.getCustomer() != null && snt.getCustomer().isRetail();
        boolean isIndividual = snt.getCustomer() != null && snt.getCustomer().isIndividual();
        boolean isCustomerBroker = snt.getCustomer() != null && snt.getCustomer().isBroker();
        boolean isSellerCommittent = snt.getSeller() != null && snt.getSeller().isCommittent();
        boolean bl = isSellerBroker = snt.getSeller() != null && snt.getSeller().isBroker();
        if ("9".equals(productSellerType) && !isOnePersonInKz) {
            isValid = this.setupContextWithValidationError(context, "oilSet.transferType", "{sntOilSetV1.productSellerType.9.wrong.transferType}");
        }
        if (sntType == SntType.RETURNED_SNT) {
            if (productSellerType == null && BooleanUtils.isFalse(LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getSeller().getNonResident()))) {
                isValid = this.setupContextWithValidationError(context, "oilSet.productSellerType", "{sntOilSetV1.productSellerType.notNull}");
            }
        } else if (sntImport == null && transferType != SntTransferTypeV1.ONE_PERSON_IN_EAEU && transferType != SntTransferTypeV1.OTHER && StringUtils.isEmpty(productSellerType)) {
            isValid = this.setupContextWithValidationError(context, "oilSet.productSellerType", "{sntOilSetV1.productSellerType.notNull}");
        }
        if (sntType != SntType.RETURNED_SNT && sntImport == null && sntExport == null && transferType == null && !"6".equals(productSellerType) && StringUtils.isEmpty(opCode)) {
            isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.operationCode.notNull}");
        }
        if (sntType == SntType.RETURNED_SNT && StringUtils.isNotEmpty(opCode)) {
            isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.returnSnt.operationCode.mustBeNull}");
        }
        if (sntType != SntType.RETURNED_SNT) {
            if (("6".equals(productSellerType) || sntImport != null || sntExport != null || transferType != null) && StringUtils.isNotEmpty(opCode)) {
                boolean transferClause;
                if ("6".equals(productSellerType) && StringUtils.isNotEmpty(opCode)) {
                    isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.sellerType.6.operationCode.mustBeNull}");
                }
                boolean importClause = sntImport != null && sntImport.getImportType() != SntImportTypeV1.IMPORT;
                boolean exportClause = sntExport != null;
                boolean bl2 = transferClause = transferType != null && !SntTransferTypeV1.ONE_PERSON_IN_EAEU.equals(transferType);
                if ((importClause || exportClause || transferClause) && StringUtils.isNotEmpty(opCode)) {
                    isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.import.export.transfer.operationCode.mustBeNull}");
                }
            } else if (!sellerTypeOpCodeMap.containsKey(productSellerType) && opCode != null) {
                isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.operationCode.unknown}");
            } else if (opCode != null) {
                List<String> allowedOpCodeList = sellerTypeOpCodeMap.get(productSellerType);
                if (StringUtils.isEmpty(opCode) || !allowedOpCodeList.contains(opCode)) {
                    isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.operationCode.unknown}");
                }
            }
        }
        if (isRetail && !"22".equals(opCode)) {
            isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.operationCode.notForCustomerRetail}");
        }
        boolean kogdNotRequiredForSellerType9 = "9".equals(productSellerType) && isOnePersonInKz;
        boolean isOnePersonInEaeu = SntTransferTypeV1.ONE_PERSON_IN_EAEU.equals(transferType);
        boolean importerCodeProductSeller = "4".equals(productSellerType);
        boolean bl3 = kogdNotRequiredForOnePersonEAEUTransfer = isOnePersonInEaeu && importerCodeProductSeller;
        if (!(!StringUtils.isEmpty(oilSet.getKogdOfRecipient()) || kogdNotRequiredForSellerType9 || BooleanUtils.isTrue(customerNonResident = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> sntV1.getCustomer().getNonResident())) || isIndividual || isRetail || "26".equals(opCode) || isOnePersonInKz || this.notRequireKogdAndPinForDesf1865(snt))) {
            isValid = this.setupContextWithValidationError(context, "oilSet.kogdOfRecipient", "{sntOilSetV1.kogdOfRecipient.notNull}");
        }
        if (!this.validateForSmallRetailOutlet(snt, context)) {
            isValid = false;
        }
        if (!isCustomerBroker && "29".equals(opCode)) {
            isValid = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.operationCode.wrongCustomerType}");
        }
        if (!isSellerBroker && "10".equals(productSellerType)) {
            isValid = this.setupContextWithValidationError(context, "oilSet.productSellerType", "{sntOilSetV1.productSellerType.wrongSellerType}");
        }
        if (!this.validatePinCode(snt, context)) {
            isValid = false;
        }
        return isValid;
    }

    private boolean validateForSmallRetailOutlet(SntV1 snt, ConstraintValidatorContext context) {
        String g6OperationCode;
        boolean result = true;
        if ((snt.getSntType() == SntType.PRIMARY_SNT || snt.getSntType() == SntType.FIXED_SNT) && snt.getCustomer() != null && snt.getCustomer().containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET) && StringUtils.isNotEmpty(g6OperationCode = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getOilSet().getOperationCode())) && !"21".equals(g6OperationCode)) {
            result = this.setupContextWithValidationError(context, "oilSet.operationCode", "{sntOilSetV1.operationCode.smallRetailOutlet.required.retail}");
        }
        return result;
    }

    private boolean validatePinCode(SntV1 snt, ConstraintValidatorContext context) {
        boolean result = true;
        SntOilSetV1 oilSet = snt.getOilSet();
        if (CollectionUtils.isNotEmpty(oilSet.getProducts())) {
            for (int i = 0; i < oilSet.getProducts().size(); ++i) {
                if (!StringUtils.isEmpty(oilSet.getProducts().get(i).getPinCode()) || this.notRequireKogdAndPinForDesf1865(snt)) continue;
                result = this.setupContextWithValidationError(context, SntProductTypeV1.OIL.getProductsPath() + String.format("[%d].pinCode", i), "{sntOilProductV1.pinCode.notNull}");
            }
        }
        return result;
    }

    private boolean notRequireKogdAndPinForDesf1865(SntV1 snt) {
        SntOilSetV1 oilSet = snt.getOilSet();
        SntType sntType = snt.getSntType();
        String opCode = oilSet.getOperationCode();
        String productSellerType = oilSet.getProductSellerType();
        SntImportV1 sntImport = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getSntImport());
        SntImportTypeV1 sntImportType = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getSntImport().getImportType());
        SntExportV1 sntExport = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getSntExport());
        SntTransferTypeV1 transferType = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> snt.getTransferType());
        if ((sntType == SntType.PRIMARY_SNT || sntType == SntType.FIXED_SNT) && sntImport != null && sntImportType == SntImportTypeV1.IMPORT && "22".equals(opCode) && "4".equals(productSellerType)) {
            return true;
        }
        if (sntType == SntType.RETURNED_SNT && sntExport != null && sntExport.getExportType() == SntExportTypeV1.EXPORT && "22".equals(opCode) && "4".equals(productSellerType)) {
            return true;
        }
        boolean isOnePersonInKz = SntTransferTypeV1.ONE_PERSON_IN_KZ.equals(transferType);
        if (isOnePersonInKz && "9".equals(productSellerType)) {
            return true;
        }
        boolean isOnePersionInEaeu = SntTransferTypeV1.ONE_PERSON_IN_EAEU.equals(transferType);
        boolean importerCodeProductSeller = "4".equals(productSellerType);
        return isOnePersionInEaeu && importerCodeProductSeller;
    }

    static {
        sellerTypeOpCodeMap.put("1", Collections.unmodifiableList(Arrays.asList("19", "20", "21", "22", "25", "26", "28", "29")));
        sellerTypeOpCodeMap.put("2", Collections.unmodifiableList(Arrays.asList("21", "22", "25", "26", "29")));
        sellerTypeOpCodeMap.put("3", Collections.unmodifiableList(Arrays.asList("22", "25", "26", "29")));
        sellerTypeOpCodeMap.put("4", Collections.unmodifiableList(Arrays.asList("20", "21", "22", "25", "26", "29")));
        sellerTypeOpCodeMap.put("5", Collections.unmodifiableList(Arrays.asList("20", "21", "22", "25", "26", "29")));
        sellerTypeOpCodeMap.put("6", Collections.emptyList());
        sellerTypeOpCodeMap.put("7", Collections.emptyList());
        sellerTypeOpCodeMap.put("8", Collections.emptyList());
        sellerTypeOpCodeMap.put("10", Collections.unmodifiableList(Arrays.asList("19", "20", "21", "22", "25", "26", "28")));
        importTypesWithoutSez = Collections.unmodifiableList(SntImportTypeV1.importTypesWithoutSez());
    }
}

