/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntProductIdCheckV1;
import ru.uss.vstore.utils.GsvsCodeUtils;

public class SntProductIdValidatorV1
extends AbstractClassLevelValidator<SntProductIdCheckV1, SntV1> {
    private static final List<SntImportTypeV1> notRequireProductIdImportTypes = Arrays.asList(SntImportTypeV1.IMPORT, SntImportTypeV1.IMPORT_FOR_PROCESSING, SntImportTypeV1.TEMPORARY_IMPORT, SntImportTypeV1.IMPORT_OF_TEMPORARY_EXPORTED_PRODUCT);
    private static final List<SntExportTypeV1> notRequiredVstoreTnvedExportTypes = Arrays.asList(SntExportTypeV1.EXPORT, SntExportTypeV1.EXPORT_FOR_PROCESSING, SntExportTypeV1.TEMPORARY_EXPORT, SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT, SntExportTypeV1.EXPORT_FROM_SEZ);

    @Override
    public void initialize(SntProductIdCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext constraintValidatorContext) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        if (sntV1 == null) {
            return true;
        }
        boolean result = true;
        SntImportTypeV1 sntImportTypeV1 = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType());
        boolean isImport = sntImportTypeV1 != null && notRequireProductIdImportTypes.contains(sntImportTypeV1);
        boolean isImportSezForNonResident = sntImportTypeV1 == SntImportTypeV1.IMPORT_IN_SEZ && BooleanUtils.isTrue(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getNonResident()));
        boolean isTransferTypeOnePersonEaeuSellerNonRedisent = BooleanUtils.isTrue(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getNonResident())) && sntV1.getTransferType() != null && SntTransferTypeV1.ONE_PERSON_IN_EAEU.equals(sntV1.getTransferType());
        String sellerRegisterCountryCode = sntV1.getSeller() == null ? null : sntV1.getSeller().getCountryCode();
        boolean isSellerKzCounty = "KZ".equalsIgnoreCase(sellerRegisterCountryCode);
        boolean isOtherTransferFromNotEaeu = SntTransferTypeV1.OTHER.equals(sntV1.getTransferType()) && !isSellerKzCounty;
        boolean isReturnedAsImport = isImport && SntType.RETURNED_SNT.equals(sntV1.getSntType());
        boolean isReturnedAsExport = sntV1.getSntExport() != null && SntExportTypeV1.EXPORT.equals(sntV1.getSntExport().getExportType()) && SntType.RETURNED_SNT.equals(sntV1.getSntType());
        boolean isImportOfTemporalExport = SntImportTypeV1.IMPORT_OF_TEMPORARY_EXPORTED_PRODUCT.equals(sntImportTypeV1);
        boolean isProductIdRequired = isImportOfTemporalExport || isReturnedAsImport || !isImport && !isImportSezForNonResident && !isTransferTypeOnePersonEaeuSellerNonRedisent && !isOtherTransferFromNotEaeu;
        isProductIdRequired &= !isReturnedAsExport;
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = sntV1.getProductsByType();
        if (productsByType != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                List<? extends SntBaseProductV1> sntAbstractProducts = productsByType.get((Object)sntProductType);
                for (int i = 0; i < sntAbstractProducts.size(); ++i) {
                    SntAbstractProduct product = sntAbstractProducts.get(i);
                    boolean isDeclarationNumberForSntNotRequired = isImport || isImportSezForNonResident || isTransferTypeOnePersonEaeuSellerNonRedisent;
                    if ((isDeclarationNumberForSntNotRequired &= !isImportOfTemporalExport) && !isReturnedAsImport && StringUtils.isNotEmpty(product.getProductId())) {
                        this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productId", i), "{sntBaseProductV1.productId.mustBuNull}");
                        result = false;
                    }
                    if (isProductIdRequired && StringUtils.isEmpty(product.getProductId())) {
                        this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productId", i), "{sntBaseProductV1.productId.notNull}");
                        result = false;
                    }
                    if (!isProductIdRequired || StringUtils.isEmpty(product.getProductId()) || GsvsCodeUtils.isValidGsvsExtendedSntCode(product.getProductId()) || GsvsCodeUtils.NO_PRODUCT_ID_CODE.equals(product.getProductId())) continue;
                    this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productId", i), "{sntBaseProductV1.productId.invalid}");
                    result = false;
                }
            }
        }
        return result;
    }

    private boolean validateCorrectProductIdExistence(SntV1 sntV1, ConstraintValidatorContext constraintValidatorContext) {
        boolean isImportSezForNonResident;
        if (sntV1.getSntType() == SntType.RETURNED_SNT || SntTransferTypeV1.ONE_PERSON_IN_EAEU == sntV1.getTransferType() || SntImportTypeV1.importTypesWithoutSez().contains(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType())) || notRequiredVstoreTnvedExportTypes.contains(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType()))) {
            return true;
        }
        SntImportTypeV1 sntImportTypeV1 = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType());
        boolean bl = isImportSezForNonResident = sntImportTypeV1 == SntImportTypeV1.IMPORT_IN_SEZ && BooleanUtils.isTrue(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getNonResident()));
        if (isImportSezForNonResident) {
            return true;
        }
        boolean hasCorrectProductId = sntV1.getProducts().stream().anyMatch(p -> StringUtils.isNotEmpty(p.getProductId()) && GsvsCodeUtils.isValidGsvsExtendedSntCode(p.getProductId()));
        if (!hasCorrectProductId) {
            this.addConstraintViolation(constraintValidatorContext, "products", "{sntBaseProductV1.productId.noOneVstoreProduct}");
            return false;
        }
        return true;
    }
}

