/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntProductNumberCheckV1;

public class SntProductNumberValidatorV1
extends AbstractClassLevelValidator<SntProductNumberCheckV1, SntV1> {
    @Override
    public void initialize(SntProductNumberCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext constraintValidatorContext) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        if (sntV1 == null) {
            return true;
        }
        boolean result = true;
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = sntV1.getProductsByType();
        if (productsByType != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                String productNumber;
                int i;
                List<? extends SntBaseProductV1> sntAbstractProducts = productsByType.get((Object)sntProductType);
                int productsCount = sntAbstractProducts.size();
                if (SntType.PRIMARY_SNT.equals(sntV1.getSntType())) {
                    LinkedHashMap<Integer, Boolean> productByPositionMap = new LinkedHashMap<Integer, Boolean>();
                    for (i = 0; i < productsCount; ++i) {
                        productByPositionMap.put(i + 1, false);
                    }
                    for (i = 0; i < productsCount; ++i) {
                        productNumber = ((SntAbstractProduct)sntAbstractProducts.get(i)).getProductNumber();
                        Integer intProductNumber = null;
                        try {
                            intProductNumber = Integer.valueOf(productNumber);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        Boolean positionResult = (Boolean)productByPositionMap.get(intProductNumber);
                        if (positionResult == null) {
                            this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productNumber", i), "{sntBaseProductV1.productNumber.outOfBounds.error}");
                            result = false;
                            continue;
                        }
                        if (positionResult.equals(true)) {
                            this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productNumber", i), "{sntBaseProductV1.productNumber.duplicate.error}");
                            result = false;
                            continue;
                        }
                        productByPositionMap.put(intProductNumber, true);
                    }
                    if (!productByPositionMap.containsValue(false)) continue;
                    this.addConstraintViolation(constraintValidatorContext, sntProductType.getProductsPath(), "{sntBaseProductV1.productNumber.incomplete}");
                    result = false;
                    continue;
                }
                HashSet<String> numbersSet = new HashSet<String>();
                for (i = 0; i < productsCount; ++i) {
                    productNumber = ((SntAbstractProduct)sntAbstractProducts.get(i)).getProductNumber();
                    if (numbersSet.add(productNumber)) continue;
                    this.addConstraintViolation(constraintValidatorContext, String.format(sntProductType.getProductsPath() + "[%d].productNumber", i), "{sntBaseProductV1.productNumber.duplicate.error}");
                    result = false;
                }
            }
        }
        return result;
    }
}

