/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntProductPriceDigitsFormatV1;

public class SntProductPriceDigitsFormatValidatorV1
extends AbstractClassLevelValidator<SntProductPriceDigitsFormatV1, SntV1> {
    private static Map<SntProductTypeV1, String> messageByProductType = new HashMap<SntProductTypeV1, String>();

    @Override
    public void initialize(SntProductPriceDigitsFormatV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        boolean isExport = snt.getSntExport() != null;
        boolean isContract = snt.getSharingParticipantContract() != null && snt.getSharingParticipantContract().getSellerDate() != null && snt.getSharingParticipantContract().getSellerNumber() != null;
        boolean isNonResident = snt.getCustomer() != null && BooleanUtils.isTrue(snt.getCustomer().getNonResident());
        String currencyCode = snt.getCurrencyCode();
        boolean isKztCurrency = StringUtils.isEmpty(currencyCode) || "KZT".equals(currencyCode);
        boolean allowPriceScale3 = isExport || isNonResident || isContract || !isKztCurrency;
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType = snt.getProductsByType();
        if (productsByType != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                List<? extends SntBaseProductV1> sntAbstractProducts = productsByType.get((Object)sntProductType);
                if (sntAbstractProducts == null) continue;
                for (int i = 0; i < sntAbstractProducts.size(); ++i) {
                    int scale;
                    SntAbstractProduct product = sntAbstractProducts.get(i);
                    if (product.getPrice() == null || (scale = product.getPrice().scale()) <= 3 && (scale != 3 || allowPriceScale3)) continue;
                    context.buildConstraintViolationWithTemplate("{" + messageByProductType.get((Object)sntProductType) + '}').addPropertyNode(String.format(sntProductType.getProductsPath() + "[%d].price", i)).addConstraintViolation();
                    result = false;
                }
            }
        }
        return result;
    }

    static {
        messageByProductType.put(SntProductTypeV1.EXPORT_CONTROL_PRODUCT, "sntExportControlProductSetV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.OTHER_PRODUCT_WITH_DIGITAL_MARK, "sntOtherProductWithDigitalMarkV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.TOBACCO, "sntTobaccoProductV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.BIOFUEL, "sntBiofuelProductV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.OIL, "sntOilProductV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.ALCOHOL_EXCEPT_BEER, "sntAlcoholExceptBeerProductV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.BEER, "sntAlcoholBeerProductV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.WINE_MATERIAL, "sntWineMaterialProductV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.ETHANOL, "sntEthanolProductV1.price.incorrect");
        messageByProductType.put(SntProductTypeV1.PRODUCT, "sntProductV1.price.incorrect");
    }
}

