/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntProductNameCheckV1;

public class SntProductProductNameValidatorV1
extends AbstractClassLevelValidator<SntProductNameCheckV1, SntV1> {
    @Override
    public void initialize(SntProductNameCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        Map<SntProductTypeV1, List<? extends SntBaseProductV1>> productsByType;
        boolean isImport;
        context.disableDefaultConstraintViolation();
        boolean result = true;
        boolean bl = isImport = snt.getSntImport() != null;
        if (isImport && (productsByType = snt.getProductsByType()) != null) {
            for (SntProductTypeV1 sntProductType : productsByType.keySet()) {
                List<? extends SntBaseProductV1> sntAbstractProducts = productsByType.get((Object)sntProductType);
                if (sntAbstractProducts == null) continue;
                for (int i = 0; i < sntAbstractProducts.size(); ++i) {
                    SntBaseProductV1 product = sntAbstractProducts.get(i);
                    if (!StringUtils.isNotEmpty(product.getProductName()) || product.getProductName().length() <= 1024) continue;
                    context.buildConstraintViolationWithTemplate("{sntCommonProductV1.import.productName.length}").addPropertyNode(String.format(sntProductType.getProductsPath() + "[%d].productName", i)).addConstraintViolation();
                    result = false;
                }
            }
        }
        return result;
    }
}

