/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntSellerV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.snt.version.v1.SntSellerNonResidentCheckV1;

public class SntSellerNonResidentValidatorV1
extends AbstractClassLevelValidator<SntSellerNonResidentCheckV1, SntV1> {
    @Override
    public void initialize(SntSellerNonResidentCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        SntSellerV1 sntSellerV1;
        boolean isNonResidentRequired = false;
        if (SntType.RETURNED_SNT.equals(sntV1.getSntType())) {
            String ethanolOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getEthanolProductSet().getOperationCode());
            String alcoholBeerOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholBeerProductSet().getOperationCode());
            String alcoholExceptBeerOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholExceptBeerProductSet().getOperationCode());
            String oilOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getOilSet().getOperationCode());
            String biofuelOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getBiofuelSet().getOperationCode());
            if ("15".equals(ethanolOpCode) || "15".equals(alcoholBeerOpCode) || "15".equals(alcoholExceptBeerOpCode) || "26".equals(oilOpCode) || "34".equals(biofuelOpCode)) {
                isNonResidentRequired = true;
            }
        }
        if ((sntSellerV1 = sntV1.getSeller()) != null) {
            if (isNonResidentRequired && BooleanUtils.isNotTrue(sntSellerV1.getNonResident())) {
                return this.setupContextWithValidationError(context, "seller.nonResident", this.generateNotNullFieldMessage("sntSellerV1.nonResident"));
            }
            if (sntV1.getSntType() != SntType.RETURNED_SNT && BooleanUtils.isTrue(sntSellerV1.getNonResident()) && StringUtils.isNotEmpty(sntSellerV1.getTin()) && (TinValidator.isTin(sntSellerV1.getTin()) || TinValidator.isIin(sntSellerV1.getTin()))) {
                return this.setupContextWithValidationError(context, "seller.tin", "{sntSellerV1.tinForNonResident.notValid}");
            }
        }
        return true;
    }
}

