/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntSellerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntSellerV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntSellerStatusCheckV1;

public class SntSellerStatusValidatorV1
extends AbstractClassLevelValidator<SntSellerStatusCheckV1, SntV1> {
    private static final List<SntSellerTypeV1> excludeSellerTransferTypes = Collections.unmodifiableList(Arrays.asList(SntSellerTypeV1.LAWYER, SntSellerTypeV1.NOTARY, SntSellerTypeV1.MEDIATOR, SntSellerTypeV1.BAILIFF, SntSellerTypeV1.INDIVIDUAL, SntSellerTypeV1.RETAIL, SntSellerTypeV1.RETAILER, SntSellerTypeV1.PHARMACEUTIC_PRODUCER, SntSellerTypeV1.LESSEE, SntSellerTypeV1.LESSOR, SntSellerTypeV1.COMMITTENT, SntSellerTypeV1.BROKER));

    @Override
    public void initialize(SntSellerStatusCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        SntSellerV1 seller = sntV1.getSeller();
        if (seller == null) {
            return true;
        }
        if (seller.getStatuses() == null) {
            return true;
        }
        if (!(seller.getStatuses().stream().filter(SntSellerTypeV1::hasPredefinedParticipantType).count() <= 1L || sntV1.getSntType() == SntType.RETURNED_SNT && seller.getStatuses().stream().filter(SntSellerTypeV1::hasPredefinedParticipantType).count() == 2L && seller.getStatuses().contains(SntSellerTypeV1.INDIVIDUAL) && seller.getStatuses().contains(SntSellerTypeV1.RETAIL))) {
            return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.invalid}");
        }
        if (sntV1.getSntType() == SntType.PRIMARY_SNT || sntV1.getSntType() == SntType.FIXED_SNT) {
            if (seller.isRetailer() && sntV1.getSntType() == SntType.PRIMARY_SNT) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.RETAILER.blocked}");
            }
            if (seller.isSmallRetailOutlet()) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.SMALL_RETAIL_OUTLET.blocked}");
            }
            if (seller.isLessee()) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.LESSEE.blocked}");
            }
            if (seller.isLessor()) {
                if (Boolean.TRUE.equals(seller.getNonResident())) {
                    return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.LESSOR.blocked}");
                }
                if (sntV1.getCustomer() != null && !sntV1.getCustomer().isLessee()) {
                    return this.setupContextWithValidationError(context, "seller.status", "{sntCustomerV1.status.LESSEE.not.picked}");
                }
            }
            if (seller.isPharmaceuticProducer()) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.PHARMACEUTIC_PRODUCER.blocked}");
            }
        }
        if (sntV1.getTransferType() != null && sntV1.getSeller() != null && CollectionUtils.isNotEmpty(sntV1.getSeller().getStatuses()) && CollectionUtils.containsAny(excludeSellerTransferTypes, sntV1.getSeller().getStatuses())) {
            return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.INDIVIDUAL.blocked.for.transfer}");
        }
        if (seller.containsCategory(SntSellerTypeV1.SMALL_RETAIL_OUTLET) && seller.getStatuses().size() > 1) {
            return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.SMALL_RETAIL_OUTLET.onlyOne}");
        }
        if ((sntV1.getSntImport() != null || sntV1.getSntExport() != null || sntV1.getTransferType() != null) && seller.containsCategory(SntSellerTypeV1.SMALL_RETAIL_OUTLET)) {
            return this.setupContextWithValidationError(context, "seller.status", "{sntSellerrV1.status.SMALL_RETAIL_OUTLET.exportImportTransfer.denied}");
        }
        if (seller.isPawneeCustodian()) {
            if (sntV1.getSntType() == SntType.RETURNED_SNT) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.PAWNEE_CUSTODIAN.RETURNED_SNT.only}");
            }
            if (seller.getParticipantType() != DocumentParticipantType.BUSINESS) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.PAWNEE_CUSTODIAN.BUSINESS.allowed}");
            }
            if (seller.getStatuses().size() > 1) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.PAWNEE_CUSTODIAN.alone}");
            }
            if (sntV1.getTransferType() != null) {
                return this.setupContextWithValidationError(context, "seller.status", "{sntSellerV1.status.PAWNEE_CUSTODIAN.transferType.denied}");
            }
        }
        return true;
    }
}

