/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntPaperReasonTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntShippingDateCheckV1;

public class SntShippingDateValidatorV1
extends AbstractClassLevelValidator<SntShippingDateCheckV1, SntV1> {
    private static final List<SntImportTypeV1> allowNullImportTypes = Arrays.asList(SntImportTypeV1.IMPORT, SntImportTypeV1.IMPORT_FOR_PROCESSING, SntImportTypeV1.IMPORT_OF_TEMPORARY_EXPORTED_PRODUCT, SntImportTypeV1.TEMPORARY_IMPORT);
    private static final List<SntExportTypeV1> allowNullExportTypes = Arrays.asList(SntExportTypeV1.EXPORT, SntExportTypeV1.EXPORT_FOR_PROCESSING, SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT, SntExportTypeV1.TEMPORARY_EXPORT, SntExportTypeV1.AIRCRAFT_REFUELING);

    @Override
    public void initialize(SntShippingDateCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        Date shippingDate = sntV1.getShippingDate();
        if (shippingDate == null) {
            SntImportTypeV1 sntImportType = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> sntV1.getSntImport().getImportType());
            SntExportTypeV1 sntExportType = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> sntV1.getSntExport().getExportType());
            if (sntImportType != null && allowNullImportTypes.contains(sntImportType) || sntExportType != null && allowNullExportTypes.contains(sntExportType)) {
                return true;
            }
            return this.setupContextWithValidationError(context, "shippingDate", "{abstractSnt.shippingDate.notNull}");
        }
        if (sntV1.getDatePaper() != null) {
            if (SntPaperReasonTypeV1.MISSING_REQUIREMENT.equals((Object)sntV1.getReasonPaper())) {
                Date limitDay = DateTimeUtils.plusYears(DateTimeUtils.startOfTheDay(new Date()), -5);
                if (shippingDate.before(limitDay)) {
                    return this.setupContextWithValidationError(context, "shippingDate", "{abstractSnt.shippingDate.invalidDate.3}");
                }
            } else if (shippingDate.before(sntV1.getDatePaper())) {
                return this.setupContextWithValidationError(context, "shippingDate", "{abstractSnt.shippingDate.invalidDate.4}");
            }
        } else {
            Date limitDay = DateTimeUtils.plusYears(DateTimeUtils.startOfTheDay(new Date()), -5);
            if (shippingDate.before(limitDay)) {
                return this.setupContextWithValidationError(context, "shippingDate", "{abstractSnt.shippingDate.invalidDate.5}");
            }
        }
        return true;
    }
}

